@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection



@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col mb-5">
            <div class="card mb-5">
                <div class="card-body">
                    <h4 class="card-title">PAGO DE FACTURAS</h4>


                    @can('pagosfactura_store')
                    <!-- Button trigger modal -->
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modelId">
                        NUEVO PAGO DE FACTURA
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">PAGO DE FACTURA</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{route('pago-facturas.store')}}" method="post">
                                    @csrf
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <label for="">FACTURA</label>
                                            <input type="text" class="form-control" name="factura" placeholder="NUMERO DE FACTURA" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">VALOR</label>
                                            <input type="number" step="any" class="form-control" name="valor" placeholder="VALOR DE FACTURA" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">FECHA DE PAGO</label>
                                            <input type="date" class="form-control" name="fecha_pago" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">DESCRIPCION</label>
                                            <input type="text" class="form-control" name="descripcion">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                                        <button type="submit" class="btn btn-primary">Guardar</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    @endcan


                    <table class="table table-hover" id="table_id" data-page-length="15">
                        <thead>
                            <tr>
                                <th>FACTURA</th>
                                <th>DESCRIPCIÓN</th>
                                <th>VALOR </th>
                                <th>FECHA DE PAGO </th>
                                <th>ACCIÓN </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($facturas as $fac)
                            <tr>
                                <td>{{$fac->factura}}</td>
                                <td>{{$fac->descripcion}}</td>
                                <td>{{$fac->valor}}</td>
                                <td>{{$fac->fecha_pago}}</td>
                                <td>

                                    @can('pagosfactura_delete')
                                    <form action="{{route('pago-facturas.destroy', $fac->id)}}" method="post">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i> </button>
                                    </form>
                                    @endcan

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>




                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'siguiente',
                    'previous': 'atras'
                },
                'loadingRecords': 'cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });
    });
</script>
@endsection