@extends('layouts.admin')

@section('styles')

<link rel="stylesheet" href="{{asset('plugins/galeria/galeria.css')}}">

@endsection

@section('content')

<div class="row">

    <!-- Column -->
    <div class="col-lg-4 col-xlg-3 col-md-5">
        <div class="card">
            <div class="float-right">
                <a class="btn btn-primary" href="{{ route('doctores.index') }}"> <i class="fa fa-arrow-left" aria-hidden="true"></i> Atras</a>
            </div>
            <div class="card-body">
                <center class="mt-4">


                    <img width="150" src="/storage/doctores/{{ $doctore->foto }}" class="img-fluid rounded-circle" alt="{{config('app.name')}}" srcset="">
                    <br>
                    <h4 class="text-title mt-2">{{ $doctore->nombre }}</h4>
                    <hr>

                    <h6 class="card-subtitle"></h6>
                    <div class="row text-center justify-content-md-center">
                        <div class="col-4">
                            <a href="javascript:void(0)" class="link">
                                <font class="font-weight-medium">Colegiado: <b>{{$doctore->colegiado}}</b></font>
                            </a>
                        </div>
                        <div class="col-4">
                            <a href="javascript:void(0)" class="link">
                                Especialidad: <b>{{$doctore->especialidad}}</b>
                            </a>
                        </div>
                    </div>
                </center>
            </div>
            <div>
                <hr>
            </div>
            <div class="card-body">
                <small class="text-muted">Email </small>
                <h6>{{$doctore->email}}</h6>
                <small class="text-muted pt-4 db">Telefono de Casa</small>
                <h6>{{$doctore->tel_casa}}</h6>
                <small class="text-muted pt-4 db">Telefono de Oficina</small>
                <h6>{{$doctore->tel_oficina}}</h6>
                <small class="text-muted pt-4 db">Telefono Movil</small>
                <h6>{{$doctore->tel_celular}}</h6>
                <small class="text-muted pt-4 db">Cuentas Bancarias</small>
                <pre style="font-weight: bold;">{{ $doctore->cuentas}} </pre>
                <small class="text-muted pt-4 db">Web</small>
                @if ($doctore->web)
                <h6>Si</h6>
                @else
                <h6>No</h6>
                @endif
                <!-- <span class="badge badge-primary" id="micolor" style="font-size: 14px; color: black">Mi color</span> -->
                <hr>
                <!-- style="background-color: #{{$doctore->color}}" -->

                <!-- panel para ver pagos -->
                <p>
                    <a class="btn btn-primary" data-toggle="collapse" href="#contentId" aria-expanded="false" aria-controls="contentId">
                        VER PAGO
                    </a>
                </p>
                <div class="collapse" id="contentId">
                    <p><b>Total a Pagar en el Mes: </b>Q. {{number_format($total_pago, 2)}}</p>
                </div>
                <!-- fin panel panel para pagos -->

            </div>
        </div>
    </div>
    <!-- Column -->
    <!-- Column -->
    <div class="col-lg-8 col-xlg-9 col-md-7">
        <div class="card">
            <div class="card-body">

                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Historial del Mes</a>
                    </li>
                    <!-- 
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Titulos</a>
                    </li> -->

                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Reportes</a>
                    </li>

                </ul>
                <div class="tab-content" id="myTabContent">

                    <!-- historial de tratamientos realizados -->
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <p class="h1">Historial Del Mes</p>
                        @includeIf('admin.doctore.data.historial')
                    </div>
                    <!-- final de historial  -->

                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">

                        <p class="h2 mt-3">Reportes de Doctor {{$doctore->nombre}}</p>


                        @can('doctor_pagosprint')
                        <div class="row">

                            <div class="col">
                                <div class="card">
                                    <div class="card-body">

                                        <h6>PAGOS DEL MES</h6>
                                        <p class="m-b-0">IMPRIME UN REPORTE DE TODO LOS TRATAMIENTOS REALIZADOS DURANTE EL MES</p>
                                        <form action="{{route('doctores.prindPagos', $doctore->id)}}" method="get">
                                            <div class="form-group">
                                                <label for="mes">Año</label>
                                                <select class="form-control" name="ano">
                                                    @for($i = 2022; $i < 2051; $i ++) <option value="{{$i}}">Año: {{$i}}</option>
                                                        @endfor
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label for="mes">Mes</label>
                                                <select class="form-control" name="mes">
                                                    <option value="01">ENERO</option>
                                                    <option value="02">FEBRERO</option>
                                                    <option value="03">MARZO</option>
                                                    <option value="04">ABRIL</option>
                                                    <option value="05">MAYO</option>
                                                    <option value="06">JUNIO</option>
                                                    <option value="07">JULIO</option>
                                                    <option value="08">AGOSTO</option>
                                                    <option value="09">SEPTIEMBRE</option>
                                                    <option value="10">OCTUBRE</option>
                                                    <option value="11">NOVIEMBRE</option>
                                                    <option value="12">DICIEMBRE</option>
                                                </select>
                                            </div>
                                            <button type="submit" class="btn btn-success"><i class="fa fa-print" aria-hidden="true"></i></button>

                                        </form>
                                    </div>
                                </div>
                            </div>



                            <div class="col-12">

                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="m-b-0">PAGOS</h6>
                                        <p class="m-b-0">IMPRIME UN REPORTE DE LOS PORCENTAJES DE PAGO</p>
                                        <a target="_blank" href="{{route('pagos.reportPagoDocto', $doctore->id)}}" class="btn btn-info"><i class="fa fa-print" aria-hidden="true"></i></a>
                                    </div>
                                </div>

                            </div>

                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="m-b-0">DESCUENTOS</h6>
                                        <p class="m-b-0">IMPRIME UN REPORTE DE LOS DESCUENTOS REALIZADOS</p>
                                        <a target="_blank" href="{{route('des.index', $doctore->id)}}" class="btn btn-primary"><i class="fa fa-print" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endcan



                    </div>

                    <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">

                        <div class="fotorama mt-4" data-allowfullscreen="true" data-width="100%" data-ratio="800/600" data-click="false" data-nav="thumbs">
                            <img src="/storage/doctores/titulos/{{ $doctore->titulo1 }}">
                            <img src="/storage/doctores/titulos/{{ $doctore->titulo2 }}">
                            <img src="/storage/doctores/titulos/{{ $doctore->titulo3 }}">
                        </div>

                    </div>

                </div>

            </div>
        </div>
    </div>
    <!-- Column -->
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/galeria/galeria.js')}}"></script>

<script>
    $("#micolor").css('background-color', '<?php echo $doctore->color; ?>');
</script>


@endsection