@extends('layouts.admin')

@section('content')


<div class="containre-fluid">
    <div class="row justify-content-center">

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    Doctores
                </div>
                <div class="card-body text-center">
                    <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/doctor.png')}}" alt="{{config('app.name')}}">
                    <p class="card-text">Imprime El Reporte de Todos Los Doctores Mostrando Sus Pagos y Aportaciones</p>
                </div>
                <div class="card-footer text-muted">

                    <form action="{{route('doctores.reporteAllDoctor')}}" method="get" target="_blank">

                        <div class="form-group">
                            <label for="mes">Mes</label>
                            <select class="form-control" id="mes" name="mes">
                                <option value="01">Enero</option>
                                <option value="02">Febrero</option>
                                <option value="03">Marzo</option>
                                <option value="04">Abril</option>
                                <option value="05">Mayo</option>
                                <option value="06">Junio</option>
                                <option value="07">Julio</option>
                                <option value="08">Agosto</option>
                                <option value="09">Septiembre</option>
                                <option value="10">Octubre</option>
                                <option value="11">Noviembre</option>
                                <option value="12">Diciembre</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="anio">Año</label>
                            <select class="form-control" id="anio" name="anio">
                                @for ($year = 2023; $year <= 2045; $year++)
                                    <option value="{{ $year }}">{{ $year }}</option>
                                    @endfor
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary"><i class="fa fa-search" aria-hidden="true"></i></button>

                    </form>


                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    Doctores Eliminados
                </div>
                <div class="card-body text-center">
                    <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/trash.png')}}" alt="{{config('app.name')}}">
                    <p class="card-text">Imprime Un Listado de Los Doctores Eliminados</p>
                </div>
                <div class="card-footer text-muted">
                    <a class="btn btn-primary" href="{{route('doctores.reportAllDelete')}}" target="_blank" role="button"> <i class="fa fa-print" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>

    </div>
</div>


@endsection