@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <div style="display: flex; justify-content: space-between; align-items: center;">

                        <span id="card_title" style="font-size: 172%; color: white;">
                            {{ __('Doctores') }}
                        </span>

                        <div class="float-right">
                            <a href="{{ route('doctores.create') }}" class="btn btn-primary  float-right" data-placement="left">
                                {{ __('Registrar Nuevo Doctor') }}
                            </a>
                        </div>
                    </div>
                </div>
                @if ($message = Session::get('success'))
                <div class="alert alert-success">
                    <p>{{ $message }}</p>
                </div>
                @endif

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="table_id" data-page-length="15">
                            <thead class="thead">
                                <tr>
                                    <th>No</th>

                                    <th>Nombre</th>
                                    <th>Usuario</th>
                                    <th>Tel Casa</th>
                                    <th>Tel Oficina</th>
                                    <th>Tel Celular</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($doctores as $doctore)
                                <tr>
                                    <td>{{ $doctore->id }}</td>

                                    <td>{{ $doctore->nombre }}</td>
                                    <td>{{ $doctore->email }}</td>

                                    <td>{{ $doctore->tel_casa }}</td>
                                    <td>{{ $doctore->tel_oficina }}</td>
                                    <td>{{ $doctore->tel_celular }}</td>
                                    <td>

                                        @can('doctor_show')
                                        <a class="btn btn-sm btn-primary " href="{{ route('doctores.show',$doctore->id) }}"><i class="fa fa-fw fa-eye"></i> </a>
                                        @endcan

                                        @can('doctor_update')
                                        <a class="btn btn-sm btn-success text-white" href="{{ route('doctores.edit',$doctore->id) }}"><i class="fa fa-fw fa-edit"></i> </a>
                                        @endcan

                                        @can('doctor_delete')
                                        <form action="{{ route('doctores.destroy',$doctore->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Estas Seguro?')"><i class="fa fa-fw fa-trash"></i> </button>
                                        </form>
                                        @endcan

                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection