@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection



@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col mb-5">
            <div class="card mb-5">
                <div class="card-body">
                    <h4 class="card-title">Tipos de Ventas</h4>

                    <table class="table table-hover" id="table_id" data-page-length="15">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Tipo </th>
                                <th>Accion </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($categorias as $cat)
                            <tr>
                                <td>{{$cat->nombre}}</td>
                                <td>{{$cat->tipo}}</td>

                                <td>
                                    @can('categoria_show')
                                    <a class="btn btn-sm btn-primary" href="{{route('categoria.show', ['id' => $cat->id])}}"><i class="fa fa-eye" aria-hidden="true"></i> </a>
                                    @endcan

                                    @can('categoria_delete')
                                    <a class="btn btn-sm btn-danger" href="{{route('categoria.delete', ['id' => $cat->id])}}" onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i> </a>
                                    @endcan


                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>




                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'siguiente',
                    'previous': 'atras'
                },
                'loadingRecords': 'cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });
    });
</script>
@endsection