@extends('layouts.admin')


@section('content')

    <div class="row">
        <div class="col-md-6 text-center">
            TOTAL EN CAJA FUERTE: Q. {{ number_format($entradas->sum('valor') - $salidas->sum('valor'), 2) }}
        </div>


        <!-- Button trigger modal -->
        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modelId">
            CREAR NUEVO REGISTRO
        </button>

        <!-- Modal -->
        <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">nUEVO REGISTRO</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('caja-secundaria.store') }}" method="post">
                        @csrf
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="valor" class="form-label">Valor</label>
                                <input type="number" step="0.01" class="form-control" id="valor" name="valor"
                                    required>
                            </div>
                            <div class="mb-3">
                                <label for="tipo" class="form-label">Tipo</label>
                                <select class="form-control" id="tipo" name="tipo" required>
                                    <option value="" selected>Seleccione un tipo</option>
                                    <option value="ENTRADA">ENTRADA</option>
                                    <option value="SALIDA">SALIDA</option>
                                </select>
                            </div>


                            <div class="mb-3">
                                <label for="descripcion" class="form-label">Descripción</label>
                                <textarea class="form-control" id="descripcion" name="descripcion"></textarea>
                            </div>

                            <div class="form-check form-check-inline">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" name="check" id=""
                                        value="true"> REGISTRAR EN GASTO
                                </label>
                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRA</button>
                            <button type="submit" class="btn btn-primary"><i class="fas fa-save    "></i></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


    </div>

    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Entradas</h4>

                    <br>



                    @if ($entradas->isEmpty())
                        <p>No hay registros de Caja Secundaria.</p>
                    @else
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Valor</th>
                                    <th>Tipo</th>
                                    <th>Descripción</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($entradas as $cajaSecundaria)
                                    <tr>
                                        <td>{{ $cajaSecundaria->id }}</td>
                                        <td>{{ $cajaSecundaria->valor }}</td>
                                        <td>{{ $cajaSecundaria->tipo }}</td>
                                        <td>{{ $cajaSecundaria->descripcion }}</td>
                                        <td>
                                            <a href="{{ route('caja-secundaria.show', $cajaSecundaria->id) }}"
                                                class="btn btn-info">Ver</a>
                                            <a href="{{ route('caja-secundaria.edit', $cajaSecundaria->id) }}"
                                                class="btn btn-warning">Editar</a>
                                            <form action="{{ route('caja-secundaria.destroy', $cajaSecundaria->id) }}"
                                                method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger"
                                                    onclick="return confirm('¿Estás seguro de que quieres eliminar este registro?')">Eliminar</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @endif

                    <p>
                        Q. {{ number_format($entradas->sum('valor'), 2) }}
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Salidas</h4>


                    <br>

                    @if ($entradas->isEmpty())
                        <p>No hay registros de Caja Secundaria.</p>
                    @else
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Valor</th>
                                    <th>Tipo</th>
                                    <th>Descripción</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($salidas as $cajaSecundaria)
                                    <tr>
                                        <td>{{ $cajaSecundaria->id }}</td>
                                        <td>{{ $cajaSecundaria->valor }}</td>
                                        <td>{{ $cajaSecundaria->tipo }}</td>
                                        <td>{{ $cajaSecundaria->descripcion }}</td>
                                        <td>
                                            <a href="{{ route('caja-secundaria.show', $cajaSecundaria->id) }}"
                                                class="btn btn-info">Ver</a>
                                            <a href="{{ route('caja-secundaria.edit', $cajaSecundaria->id) }}"
                                                class="btn btn-warning">Editar</a>
                                            <form action="{{ route('caja-secundaria.destroy', $cajaSecundaria->id) }}"
                                                method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger"
                                                    onclick="return confirm('¿Estás seguro de que quieres eliminar este registro?')">Eliminar</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @endif
                    <p>Total: Q. {{ number_format($salidas->sum('valor'), 2) }} </p>
                </div>
            </div>
        </div>

    </div>
@endsection
