@extends('layouts.admin')

@section('content')
<div class="container">

    @can('caja_registro_gastos')
    <div class="row">

        <div class="col">
            <div class="alert alert-info alert-dismissible show" role="alert">
                <button type="button" class="close btn btn-info" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <div class="card card-info">
                    <div class="card-body" style="color:black;">
                        <h3 class="card-title text-center">REGISTRAR SALIDA</h3>

                        <form action="{{route('caja.salidaStore')}}" method="post">
                            @csrf
                            <div class="form-group">
                                <label for="exampleInputEmail1">Valor </label>
                                <input type="number" step="any" name="valor" class="form-control">
                            </div>

                            <div class="form-group">
                                <label for="">Tipo de Gasto</label>
                                <select class="form-control" name="tipo" id="">
                                    <option value="FIJO">GASTO FIJO</option>
                                    <option value="VARIABLE">GASTO VARIABLE</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputEmail1">Descripción</label>
                                <input type="text" class="form-control" name="descripcion" required>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputEmail1">Factura: </label>
                                <input type="text" class="form-control" name="factura" required>
                            </div>

                            <button type="submit" class="btn mt-2 btn-sm btn-outline-success"><i class="fas fa-save"></i> GUARDAR</button>

                        </form>

                    </div>
                    <!-- /.card-body -->
                </div>

            </div>


        </div>
    </div>
    @endcan

    <div class="row">
        <div class="col">

            <h4 class="card-title text-center display-4">Salidas de Efectivo</h4>
            <div class="card">
                <div class="card-body">
                    <table class="table table-hover" id="table_id" data-page-length="15">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Valor </th>
                                <th>Descripción</th>
                                <th>Tipo</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($entradas as $ent)
                            <tr>
                                <td>{{$ent->fecha}}</td>
                                <td>{{$ent->valor}}</td>
                                <td>{{$ent->descripcion}}</td>
                                <td>GASTO {{$ent->tipo}}</td>
                                <td>

                                    @can('caja_delete_gasto')
                                    <a href="{{route('caja.deletesalida', ['id' => $ent->id])}}" class="btn btn-sm btn-danger"> <i class="fa fa-trash" aria-hidden="true"></i> Eliminar </a>
                                    @endcan

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <div class="text-right mx-4">
                        <h2>Total de Salidas: Q. {{$total}}</h2>
                    </div>



                </div>
            </div>
        </div>
    </div>
</div>


@endsection