@extends('layouts.admin')

@section('content')

<div class="container">
    <div class="row">

        @can('caja_filtrado_gastos')
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">GASTOS</h4>
                    <p class="card-text">IMPRIME / VISUALIZA EL LISTADO DE GASTOS DE EFECTIVO FILTRADO POR FECHA</p>

                    <br>


                    <form action="{{route('caja.salidaReport')}}" method="post">
                        @csrf()
                        <div class="form-group">
                            <label for="">De (Fecha de Inicio): </label>
                            <input type="date" class="form-control" name="desde" placeholder="Fecha de Inicio" required>
                        </div>
                        <div class="form-group">
                            <label for="">Hasta (Fecha de Final): </label>
                            <input type="date" class="form-control" name="hasta" placeholder="Fecha de Fin" required>
                        </div>

                        <button type="submit" class="btn btn-primary"> <i class="fa fa-filter" aria-hidden="true"></i> Buscar </button>
                    </form>


                </div>
            </div>
        </div>
        @endcan


        @can('caja_filtrado_cajachica')
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">CAJA CHICA</h4>
                    <p class="card-text">IMPRIME / VISUALIZA EL LISTADO DE ENTRADAS A "CAJA CHICA" DE EFECTIVO FILTRADO POR FECHA</p>
                    <br>
                    <form action="{{route('caja.entradasReport')}}" method="post">
                        @csrf()
                        <div class="form-group">
                            <label for="">De (Fecha de Inicio): </label>
                            <input type="date" class="form-control" name="desde" placeholder="Fecha de Inicio" required>
                        </div>

                        <div class="form-group">
                            <label for="">Hasta (Fecha de Final): </label>
                            <input type="date" class="form-control" name="hasta" placeholder="Fecha de Fin" required>
                        </div>

                        <button type="submit" class="btn btn-primary"> <i class="fa fa-filter" aria-hidden="true"></i> Buscar </button>
                    </form>
                </div>
            </div>
        </div>
        @endcan

    </div>

    @can('caja_movimientos_filtrados')
    <div class="row">
        <div class="col-md-6">

            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Reporte de Cuadres del Mes</h4>
                    <p class="card-text">Imprime y lista un Reporte de los Cuadres Realizados</p>
                    <a class="btn btn-primary" href="{{route('caja.cuadreReport')}}" role="button"> <i class="fa fa-print" aria-hidden="true"></i> IMPRIMIR </a>
                </div>
            </div>

        </div>




        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Reporte de Cuadres Filtrado</h4>
                    <p class="card-text">Imprime y lista un Reporte de los Cuadres Realizados Filtrados por mes y Año</p>

                    <form action="{{route('caja.cuadrereportFilter')}}" method="get">

                        <div class="form-group">
                            <label for="mes">Año</label>
                            <select class="form-control" name="ano">
                                @for($i = 2021; $i < 2051; $i ++) <option value="{{$i}}">Año: {{$i}}</option>
                                    @endfor
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="mes">Mes</label>
                            <select class="form-control" name="mes">
                                @for($i = 1; $i < 13; $i ++) <option value="{{$i}}">Mes: {{$i}}</option>
                                    @endfor
                            </select>
                        </div>

                        <button class="btn btn-primary" type="submit"> <i class="fa fa-print" aria-hidden="true"></i> IMPRIMIR </button>
                    </form>
                </div>
            </div>
        </div>


    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card text-left">
                <div class="card-body">
                    <h4 class="card-title">MOVIMIENTOS DE CLINICA</h4>
                    <p class="card-text">RETORNA LOS MOVIMOS DE CLINICA DE CADA DIA EN ESPECIFICO</p>

                    <form action="{{route('caja.movimientos_dia')}}" method="post">
                        @csrf
                        <div class="form-group">
                            <label for="">MOVIMIENTOS DE LA FECHA</label>
                            <input type="date" name="fecha" class="form-control">
                            <small id="helpId" class="text-muted">MOVIMIENTOS DE LA CLINICA</small>
                        </div>


                        <button type="submit" class="btn btn-dark"><i class="fa fa-print" aria-hidden="true"></i></button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <br>
                    <h4 class="card-title">MOVIMIENTOS FILTRADOS POR FECHA</h4> <br>
                    <form action="{{route('caja.moviemintentoToDates')}}" method="post">


                        @csrf
                        <div class="form-group">
                            <label for="inicio">Fecha de Inicio</label>
                            <input type="date" class="form-control" name="inicio" required>
                        </div>
                        <div class="form-group">
                            <label for="fin">Fecha de Fin</label>
                            <input type="date" class="form-control" name="fin" required>
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-filter" aria-hidden="true"></i> Buscar
                        </button>

                    </form>
                </div>
            </div>
        </div>

    </div>

    @endcan

</div>

@endsection