@extends('layouts.admin')

@section('content')

<div class="container">
   <div class="row">
      <div class="col">
         <div class="card">
            <div class="card-body">
            
            <div class="text-center h3">CUADRE ORTODONCIA</div>


               <h4> Total Abonos: Q. {{number_format($t_orto, 2)}}</h4>
               <h4> Total de Gastos: Q. {{number_format($t_salida_orto, 2)}}</h4>
               <h4 class="text-success">Total a Cuadrar = Q. {{ number_format( $t_orto + $t_salida_orto,2) }}</h4>

               <form action="{{route('caja.cuadre_ortodoncia_store')}}" method="post">
                  @csrf


                  <input type="hidden" id="cauadre" name="cuadre" value="{{ $t_orto + $t_salida_orto }}">

                  <div class="form-group my-2">
                     <input type="text" class="form-control" name="efectivo" placeholder="TOTAL EN EFECTIVO" id="efectivo">
                  </div>

                  <div class="form-group my-2">
                     <input type="text" class="form-control" name="visas" placeholder="TOTAL EN VISAS" id="visas">
                  </div>

                  <div class="form-group my-2">
                     <input type="text" class="form-control" name="faltante" placeholder="FALTANTE" id="faltante">
                  </div>

                  <div class="text-lefth my-2">
                     <button type="button" class="btn btn-info" id="igualar"> <i class="fa fa-save mr-1"></i> Cuadrar</button>
                  </div>

                  <div class="text-right my-2">
                     <button type="submit" id="guardar" class="btn btn-success" disabled> <i class="fa fa-save mr-1"></i> Guardar Registro</button>
                  </div>

               </form>


            </div>
         </div>
      </div>
   </div>
</div>

@endsection


@section('scripts')
<script>
   $(document).ready(function() {
      var cuadre = $('#cauadre').val();
      var efectivo = $('#efectivo');
      var faltante = $('#faltante');
      var boton = $('#igualar');
      var visas = $('#visas');

      boton.click(function() {
         let total = cuadre - (parseFloat(efectivo.val()) + parseFloat(visas.val()));
         faltante.val(total);
         $('#guardar').prop('disabled', false);
      });

   });
</script>
@endsection