@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body">

                    <div class="row">

                        <div class="col-md-4">
                            <h3>Abonos</h3>
                            <h4>Efectivo: Q. {{number_format($abonos[0], 2)}} </h4>
                            <h4>Visas: Q. {{number_format($abonos[1], 2)}} </h4>
                            <h4>Transferencias: Q. {{number_format($abonos[2], 2)}}</h4>
                            <h4>Depósitos: Q. {{number_format($abonos[3], 2)}}</h4>
                            <h4>Otros: Q. {{number_format($abonos[4], 2)}} </h4>
                            <hr>
                        </div>
                        <div class="col-md-4">
                            <h4> Total en Caja Chica: Q. {{number_format($entradas, 2)}}</h4>
                            <h4> Total en Gastos: Q. {{number_format($salida, 2)}}</h4>
                        </div>
                    </div>


                    <h3>Total a Cuadrar = Q. {{ (($entradas - $salida)  + $abonos[0] + $abonos[1]+ $abonos[2]+ $abonos[3]+$abonos[4])  }}</h3>


                    <form action="{{route('caja.cuadreStore')}}" method="post">
                        @csrf

                        <input type="hidden" name="entrada" value="{{$entradas}}">
                        <input type="hidden" name="salida" value="{{$salida}}">

                        <input type="hidden" id="cauadre" name="cuadre" value="{{(($entradas - $salida)  + $abonos[0] + $abonos[1]+ $abonos[2]+ $abonos[3]+$abonos[4]) }}">



                        <div class="form-group my-2">
                            <input type="text" class="form-control" name="efectivo" placeholder="TOTAL EN EFECTIVO" id="efectivo">
                        </div>

                        <div class="form-group my-2">
                            <input type="text" class="form-control" name="visas" placeholder="TOTAL EN VISAS" id="visas">
                        </div>

                        <div class="form-group my-2">
                            <input type="text" class="form-control" name="faltante" placeholder="FALTANTE" id="faltante">
                        </div>

                        <div class="text-lefth my-2">
                            <button type="button" class="btn btn-info" id="igualar"> <i class="fa fa-save mr-1"></i> Cuadrar</button>
                        </div>

                        <div class="text-right my-2">
                            <button type="submit" id="guardar" class="btn btn-success" disabled> <i class="fa fa-save mr-1"></i> Guardar Registro</button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        var cuadre = $('#cauadre').val();
        var efectivo = $('#efectivo');
        var faltante = $('#faltante');
        var boton = $('#igualar');
        var visas = $('#visas');

        boton.click(function() {
            let total = cuadre - (parseFloat(efectivo.val()) + parseFloat(visas.val()));
            faltante.val(total);
            $('#guardar').prop('disabled', false);
        });

    });
</script>
@endsection