@extends('layouts.admin')

@section('content')
<div class="container">
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body">

                    <div class="row ">
                        <div class="cold-md-6">

                            <h4> Total en Ventas Esperadas: Q. {{number_format($ventas + $ventasMayo, 2)}}</h4>
                            <h4>Deuda de Medicamentos= Q. {{number_format($deudaMedicamento, 2)}}</h4>


                        </div>
                    </div>
                    <h3>Total a Cuadrar = Q. {{ number_format( ($ventas + $ventasMayo) - $deudaMedicamento,2) }}</h3>

                    <form action="{{route('caja.cuadre_med_store')}}" method="post">
                        @csrf
                        <input type="hidden" name="deuda_medicamento" value="{{$deudaMedicamento}}">

                        <input type="hidden" id="cauadre" name="cuadre" value="{{ ($ventas + $ventasMayo) - $deudaMedicamento }}">

                        <div class="form-group my-2">
                            <input type="text" class="form-control" name="efectivo" placeholder="TOTAL EN EFECTIVO" id="efectivo">
                        </div>

                        <div class="form-group my-2">
                            <input type="text" class="form-control" name="visas" placeholder="TOTAL EN VISAS" id="visas">
                        </div>

                        <div class="form-group my-2">
                            <input type="text" class="form-control" name="faltante" placeholder="FALTANTE" id="faltante">
                        </div>

                        <div class="text-lefth my-2">
                            <button type="button" class="btn btn-info" id="igualar"> <i class="fa fa-save mr-1"></i> Cuadrar</button>
                        </div>

                        <div class="text-right my-2">
                            <button type="submit" id="guardar" class="btn btn-success" disabled> <i class="fa fa-save mr-1"></i> Guardar Registro</button>
                        </div>

                    </form>

                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <img class="card-img-top" src="holder.js/100x180/" alt="">
                <div class="card-body">
                    <h4 class="card-title">DISTRIBUCION DE CUADRE</h4> <br>
                    Efectivo: Q. {{number_format($efectivo, 2)}} <br>
                    <!-- Tarjeta: Q. {{number_format($tarjeta, 2)}} <br> -->
                    Transferencia: Q. {{number_format($transferencia, 2)}} <br>
                    Deposito: Q. {{number_format($deposito, 2)}} <br>
                    <!-- Otros: Q. {{number_format($otro, 2)}} <br> -->
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        var cuadre = $('#cauadre').val();
        var efectivo = $('#efectivo');
        var faltante = $('#faltante');
        var boton = $('#igualar');
        var visas = $('#visas');

        boton.click(function() {
            let total = cuadre - (parseFloat(efectivo.val()) + parseFloat(visas.val()));
            faltante.val(total);
            $('#guardar').prop('disabled', false);
        });

    });
</script>
@endsection