@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection



@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col mb-5">
            <div class="card mb-5">
                <div class="card-body">
                    <h4 class="card-title">Categorias</h4>

                    <table class="table table-hover" id="table_id" data-page-length="15">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Nombre</th>
                                <th>Accion </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($bodegas as $bodega)
                            <tr>
                                <td>{{$bodega->id}}</td>
                                <td>{{$bodega->nombre}}</td>
                                <td>
                                    <a class="btn btn-sm btn-primary " href="{{ route('bodegak.show',$bodega->id) }}"><i class="fa fa-fw fa-eye"></i> </a>

                                    <form action="{{ route('bodegak.delete',$bodega->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Estas Seguro?')"><i class="fa fa-fw fa-trash"></i> </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>




                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'siguiente',
                    'previous': 'atras'
                },
                'loadingRecords': 'cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });
    });
</script>
@endsection