@extends('layouts.admin')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col ">
            <div class="card p-4 mb-3">
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">Articulo</a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">Actualizar</a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link " target="_blank" href="{{route('articulo.exportdata', ['id' => $articulo->id])}}">Imprimir Codigo</a>
                    </li>

                </ul>
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active text-center" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">

                        <h4> Articulo / {{$articulo->nombre}}</h4>

                        <div class="card p-3">
                            <div class="center">
                                <img class="card-img-top img-fluid" style="width: 300px;" src="{{$articulo->img}}" alt="{{$articulo->nombre}}">
                            </div>
                            <div class="card-body row">


                                <div class="col-md-6">
                                    <h2 class="text-uppercase text-center">{{$articulo->nombre}}</h2>
                                    <pre class="card-text text-capitalize">Descripcion: {{$articulo->descripcion}} / {{$articulo->nomCat}} </pre>
                                    <pre class="card-text text-capitalize">Descripcion Interna: {{$articulo->descripcion_interna}} </pre>
                                    <p class="card-text text-capitalize">Codigo De Barras: {{$articulo->cod_barras}}</p>
                                    <p class="card-text">Precio Venta: Q. {{number_format($articulo->p_venta, 2)}}</p>
                                    <p class="card-text">Precio Costo: Q. {{number_format($articulo->p_costo, 2)}}</p>

                                    <!-- Q. number_format($producto->p_venta, 2) -->

                                    <p class="card-text">Utilidad del Articulo: Q. {{$articulo->p_venta - $articulo->p_costo}}</p>
                                    <p class="card-text">Fecha de Registro: {{$articulo->created_at}}</p>

                                    <p>Minimo de Stock: {{$articulo->min_stock}}</p>

                                    <p class="card-text">Existencia:
                                        @if( number_format($articulo->lotes->sum('cantidad') ?? 0, 2) > $articulo->min_stock)
                                        <span class="badge bg-success" style="font-size: 15px;">{{$articulo->lotes->sum('cantidad')}}</span>
                                        @else
                                        <span class="badge bg-warning" style="font-size: 15px;">{{$articulo->lotes->sum('cantidad')}} (Poca existencia)</span>
                                        @endif
                                    </p>
                                </div>

                                <div class="col-md-6">

                                    <h3>DATOS DE PROVEEDOR</h3>
                                    <p>Nombre: {{$articulo->proveedor->nombre}}</p>
                                    <p>Telefono Primario: {{$articulo->proveedor->telefono1}}</p>
                                    <p>Telefono Secundario: {{$articulo->proveedor->telefono2}}</p>
                                    <p>Articulos Que Provee</p>
                                    <pre>{{$articulo->proveedor->articulos}}</pre>
                                </div>
                            </div>
                        </div>




                    </div>
                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                        <h4>Actualizar</h4>


                        <form action="{{route('articulo.update', ['id' => $articulo->id])}}" method="POST">
                            @csrf
                            @method('PUT')



                            <div class="form-row">
                                <div class="form-group col-md">
                                    <label for="inputEmail4">Nombre:</label>
                                    <input type="text" class="form-control" name="nombre" value="@isset($articulo->nombre){{ $articulo->nombre }}@endisset" required>
                                </div>
                            </div>


                            <hr>
                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label for="inputCity">Precio Venta:</label>
                                    <input type="number" class="form-control" required name="p_venta" step="any" value="@isset($articulo->p_venta){{ $articulo->p_venta }}@endisset">
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="inputState">Precio Costo:</label>
                                    <input type="number" class="form-control" required name="p_costo" step="any" value="@isset($articulo->p_costo){{ $articulo->p_costo }}@endisset">
                                </div>

                                <div class="form-group col-md-3 d-none">
                                    <label for="inputZip">Cantidad / Stock: </label>
                                    <input type="number" class="form-control" name="stock" value="{{$articulo->lotes->sum('cantidad')}}">
                                </div>

                                <div class="col-md-3">
                                    <label for="">Notificacion de Minimo</label>
                                    <input type="number" class="form-control text-uppercase" name="min_stock" value="@isset($articulo->min_stock){{ $articulo->min_stock }}@endisset" value="0">
                                </div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class=" col-md-4">
                                    <label for="inputCity">Codigo de Barras</label>
                                    <input type="text" class="form-control" name="cod_barras" value="@isset($articulo->cod_barras){{ $articulo->cod_barras }}@endisset">
                                </div>


                                <div class=" col-md-4">
                                    <label for="inputState">Categoria / Tipo de Venta</label>
                                    <select class="form-control" name="categoria_id" required>
                                        <option value="@isset($articulo->categoria_id){{ $articulo->categoria_id }}@endisset">
                                            @if (isset($articulo->categoria_id))
                                            {{$articulo->categoria->nombre}}
                                            @else
                                            Seleccione Categoria
                                            @endif
                                        </option>
                                        @foreach($categoria as $cat)
                                        <option value="{{$cat->id}}">{{$cat->nombre}} / {{$cat->tipo}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <label for="inputState">Proveedor</label>
                                    <select class="form-control" name="proveedor_id" required>
                                        <option value="@isset($articulo->proveedor_id){{ $articulo->proveedor_id }}@endisset">
                                            @if (isset($articulo->proveedor_id))
                                            {{$articulo->proveedor->nombre}}
                                            @else
                                            Seleccione Proveedor
                                            @endif
                                        </option>
                                        @foreach($proveedor as $pro)
                                        <option value="{{$pro->id}}">{{$pro->nombre}} / {{$pro->articulos}}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            <hr>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="inputZip">Imagen</label>
                                    <input type="text" class="form-control" name="img" value="@isset($articulo->img){{ $articulo->img }}@endisset">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputZip">Fecha Expiracion</label>
                                    <input type="date" class="form-control" name="fecha_promo" value="@isset($articulo->fecha_promo){{ $articulo->fecha_promo }}@endisset">
                                </div>
                            </div>

                            <div class="row">

                                <div class="form-group col-md-6">
                                    <label for="">Descripcion:</label>
                                    <textarea class="form-control" name="descripcion" rows="10">@if(isset($articulo->descripcion)){{$articulo->descripcion}}@endif</textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="">Descripcion Interna:</label>
                                    <textarea class="form-control" placeholder="Colocamos Descuentos,  O informacion Util para el futuro esto no se vera en el recibo" name="descripcion_interna" rows="10">@if(isset($articulo->descripcion_interna)){{$articulo->descripcion_interna}}@endif</textarea>
                                </div>

                            </div>



                            <h2>Lotes de stock</h2>
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Cantidad</th>
                                        <th>Fecha de caducidad</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="lotes-table">
                                    @foreach ($data->lotes as $index => $lote)
                                    <tr>
                                        <td><input type="number" class="form-control" name="lotes[{{ $index }}][cantidad]" value="{{ $lote->cantidad }}"></td>
                                        <td><input type="date" class="form-control" name="lotes[{{ $index }}][fecha_caducidad]" value="{{ $lote->fecha_caducidad }}"></td>
                                        <!-- Añadimos el botón de eliminar también a los lotes existentes -->
                                        <td><button type="button" class="btn btn-danger btn-sm eliminar-lote">Eliminar</button></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <button type="button" class="btn btn-primary" id="agregar-lote">Agregar lote</button>

                            <button type="submit" class="btn btn-warning btn-block"> <i class="fas fa-save    "></i> Actualizar</button>
                        </form>

                    </div>

                </div>

            </div>
        </div>
    </div>
</div>

@endsection


@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const agregarLoteBtn = document.getElementById('agregar-lote');
        const lotesTableBody = document.getElementById('lotes-table');

        // Inicializar loteCounter con el número de filas existentes en la tabla
        // Esto asegura que los nuevos lotes empiecen con un índice único
        let loteCounter = lotesTableBody.children.length;

        // Función para adjuntar el evento de eliminar a un botón
        function attachDeleteEvent(button) {
            button.addEventListener('click', function() {
                // Elimina la fila padre del botón
                button.closest('tr').remove();
                // Opcional: Reindexar los campos después de una eliminación
                // Aunque no siempre es necesario si el backend no espera índices secuenciales
                reindexLotes();
            });
        }

        // Función para reindexar los campos de lotes después de una eliminación
        // Esto es útil si el backend espera índices secuenciales o si se van a añadir más lotes
        function reindexLotes() {
            const rows = lotesTableBody.querySelectorAll('tr');
            rows.forEach((row, index) => {
                row.querySelector('[name*="[cantidad]"]').name = `lotes[${index}][cantidad]`;
                row.querySelector('[name*="[fecha_caducidad]"]').name = `lotes[${index}][fecha_caducidad]`;
            });
            // Actualizar el contador para que la próxima adición use el índice correcto
            loteCounter = rows.length;
        }

        // Adjuntar eventos de eliminar a los botones existentes al cargar la página
        lotesTableBody.querySelectorAll('.eliminar-lote').forEach(attachDeleteEvent);


        agregarLoteBtn.addEventListener('click', function() {
            console.log('click');
            const newRow = document.createElement('tr');
            newRow.innerHTML = `
                <td><input type="number" class="form-control" name="lotes[${loteCounter}][cantidad]" required></td>
                <td><input type="date" class="form-control" name="lotes[${loteCounter}][fecha_caducidad]" required></td>
                <td><button type="button" class="btn btn-danger btn-sm eliminar-lote">Eliminar</button></td>
            `;
            lotesTableBody.appendChild(newRow);

            // Adjuntar evento de eliminar al nuevo botón
            const eliminarLoteBtn = newRow.querySelector('.eliminar-lote');
            attachDeleteEvent(eliminarLoteBtn);

            loteCounter++; // Incrementar el contador para el próximo lote
        });
    });
</script>
@endsection