@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
<style>
    .bg-alerta-minimo {
        background-color: #e09e4d;
    }
</style>
@endsection

@section('content')

<div class="container-fluid ">
    <div class="row">
        <div class="col">
            <div class="card mb-4">
                <div class="card-body">
                    <h4 class="card-title">Listado de Artículos</h4>
                    <div class="table-responsive  table-responsive mb-5">
                        <table class="table table-data table-hover" id="table_id" data-page-length="15">
                            <thead style=" cursor: pointer;">
                                <tr style="background-color: black; color:white;">
                                    <th style="color: white;">Nombre <i class="fa fa-sort"></i> </th>
                                    <th style="color: white;">Descripción <i class="fa fa-sort"></i> </th>
                                    <th style="color: white;">Categoría <i class="fa fa-sort"></i></th>
                                    <th style="color: white;">Precio Venta <i class="fa fa-sort"></i></th>
                                    <th style="color: white;">Stock <i class="fa fa-sort"></i></th>
                                    <th style="color: white;">Mínimo Stock <i class="fa fa-sort"></i></th>
                                    <th style="color: white;">Código de Barras <i class="fa fa-sort"></i></th>
                                    <th style="color: white;"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($articulos as $art)

                                <tr class="tr-shadow @if ($art->stock < $art->min_stock)
                                bg-alerta-minimo text-white
                        @endif">
                                    <td>{{$art->nombre}}</td>
                                    <td>{{$art->descripcion}}</td>
                                    <td>{{$art->categoria_id}}</td>
                                    <td>{{number_format($art->p_venta, 2)}}</td>
                                    <td>{{$art->lotes->sum('cantidad')}}</td>
                                    <td><span class="badge badge-warning" style="background-color: red;">{{$art->min_stock}}</span></td>
                                    <td>{{$art->cod_barras}}</td>
                                    <td>

                                        @can('medicamento_show')
                                        <a class="item btn btn-success" href="{{route('articulo.show', ['id' => $art->id])}}" data-toggle="tooltip" data-placement="top" title="Ver Datos de  {{$art->nombre}}" data-original-title="Editar {{$art->nombre}}">
                                            <i class="fa fa-eye" aria-hidden="true"></i>
                                        </a>
                                        @endcan

                                        @can('medicamento_delete')
                                        <a class="item btn btn-danger" data-toggle="tooltip" data-placement="top" title="" data-original-title="Eliminar {{$art->nombre}}" href="{{route('articulo.delete', ['id' => $art->id])}}" onclick="return confirm('¿Esta Seguro de Eliminar?')">
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </a>
                                        @endcan

                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection