@extends('layouts.admin')


@section('content')

<div class="container-fluid mb-5">

    <div class="card card-solid">
        <div class="card-body pb-0">
            <div class="row d-flex align-items-stretch">
                <div class="col">
                    <div class="card p-4">


                        <h4 class="card-title text-uppercase text-center display-4">nuevo articulo</h4>

                        <form action="{{route('articulo.store')}}" method="post" autocomplete="off">
                            @csrf
                            @include('admin.articulos/forms/store')

                            <h2>Lotes de stock</h2>
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Cantidad</th>
                                        <th>Fecha de caducidad</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="lotes-table">
                                </tbody>
                            </table>

                            <button type="button" class="btn btn-primary" id="agregar-lote">Agregar lote</button>


                            <hr>


                            <button type="submit" class="btn btn-success btn-block"><i class="fas fa-save    "></i> Registrar</button>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>



@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const agregarLoteBtn = document.getElementById('agregar-lote');
        const lotesTableBody = document.getElementById('lotes-table');
        let loteCounter = 0;

        agregarLoteBtn.addEventListener('click', function() {
            console.log('click');
            const newRow = document.createElement('tr');
            newRow.innerHTML = `
        <td><input type="number" class="form-control" name="lotes[${loteCounter}][cantidad]"></td>
        <td><input type="date" class="form-control" name="lotes[${loteCounter}][fecha_caducidad]"></td>
        <td><button type="button" class="btn btn-danger btn-sm eliminar-lote">Eliminar</button></td>
      `;
            lotesTableBody.appendChild(newRow);
            loteCounter++;

            // Agregar evento para eliminar lote
            const eliminarLoteBtn = newRow.querySelector('.eliminar-lote');
            eliminarLoteBtn.addEventListener('click', function() {
                newRow.remove();
            });
        });
    });
</script>
@endsection