@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
<style>
    .bg-alerta-minimo {
        background-color: #e09e4d;
    }
</style>
@endsection

@section('content')

<div class="container-fluid ">
    <div class="row">
        <div class="col">
            <div class="card mb-4">
                <div class="card-body">
                    <h4 class="card-title">Listado de Articulos</h4>
                    <div class="table-responsive  table-responsive mb-5">
                        <table class="table table-data table-hover" id="table_id" data-page-length="15">
                            <thead style=" cursor: pointer;">
                                <tr>
                                    <th>Nombre </th>
                                    <th>Descripción </th>
                                    <th>Precio Costo </th>
                                    <th>Precio Venta </th>
                                    <th>Stock </th>

                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data as $art)
                                <tr>

                                    <form action="{{route('articulo.update', $art->id)}}" method="post">
                                        @csrf
                                        @method('PUT')


                                        <td> <input type="text" value="{{$art->nombre}}" name="nombre"> </td>
                                        <td> <input type="text" value="{{$art->descripcion}}" name="descripcion"> </td>
                                        <td> <input type="text" value="{{$art->p_costo}}" name="p_costo"> </td>
                                        <td> <input type="text" value="{{$art->p_venta}}" name="p_venta"></td>
                                        <td> <input type="text" value="{{$art->stock}}" name="stock"> </td>
                                        <td>

                                            <button type="submit" class="btn btn-primary">ACTUALIZAR</button>

                                        </td>
                                    </form>

                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection