@extends('layouts.admin')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col ">
            <div class="card p-4 mb-3">
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">Articulo</a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">Actualizar</a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link " target="_blank" href="{{route('articuloK.exportdata', ['id' => $articulo->id])}}">Imprimir Codigo</a>
                    </li>

                </ul>
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active text-center" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">

                        <h4 class="text-center text-uppercase"> {{$articulo->bodega}} {{$articulo->color}} {{$articulo->talla}}</h4>

                        <div class="card p-3">
                            <div class="card-body row">


                                <div class="col-md-6">

                                    <p class="card-text text-capitalize">Codigo De Barras: {{$articulo->codigo}}</p>
                                    <p class="card-text">Precio Venta: Q. {{number_format($articulo->p_venta, 2)}}</p>
                                    <p class="card-text">Precio Costo: Q. {{number_format($articulo->p_costo, 2)}}</p>

                                    <!-- Q. number_format($producto->p_venta, 2) -->

                                    <p class="card-text">Utilidad del Articulo: Q. {{$articulo->p_venta - $articulo->p_costo}}</p>


                                    <p>Minimo de Stock: {{$articulo->min_stock}}</p>

                                    <p class="card-text">Existencia:
                                        @if($articulo->stock > $articulo->min_stock)
                                        <span class="badge bg-success" style="font-size: 15px;">{{$articulo->stock}}</span>
                                        @else
                                        <span class="badge bg-warning" style="font-size: 15px;">{{$articulo->stock}} (Poca existencia)</span>
                                        @endif
                                    </p>
                                </div>

                                <div class="col-md-6">

                                    <h3>DATOS DE BODEGA</h3>
                                    <p>Nombre: {{$articulo->bodega}}</p>


                                </div>
                            </div>
                        </div>




                    </div>
                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                        <h4>Actualizar</h4>


                        <form action="{{route('articuloK.update', ['id' => $articulo->id])}}" method="POST">
                            @csrf
                            @method('PUT')
                            @include('admin.articuloK/forms/store')

                            <button type="submit" class="btn btn-warning btn-block"> <i class="fas fa-save    "></i> Actualizar</button>
                        </form>


                    </div>

                </div>

            </div>
        </div>
    </div>
</div>

@endsection