@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
<style>
    .bg-alerta-minimo {
        background-color: #e09e4d;
    }
</style>
@endsection

@section('content')

<div class="container-fluid ">
    <div class="row">
        <div class="col">
            <div class="card mb-4">
                <div class="card-body">
                    <h4 class="card-title">Listado de Articulos</h4>
                    <div class="table-responsive  table-responsive mb-5">
                        <table class="table table-data table-hover" id="table_id" data-page-length="15">
                            <thead style="cursor: pointer;">
                                <tr>
                                    <th>Nombre <i class="fa fa-sort"></i> </th>
                                    <th>Color <i class="fa fa-sort"></i></th>
                                    <th>Precio Venta <i class="fa fa-sort"></i></th>
                                    <th>Stock <i class="fa fa-sort"></i></th>
                                    <th>Codigo de Barras <i class="fa fa-sort"></i></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($articulos as $art)

                                <tr class="tr-shadow @if ($art->stock < $art->min_stock)
                                bg-alerta-minimo text-white
                        @endif">
                                    <td>{{$art->bodega}}</td>
                                    <td>{{$art->color}}</td>
                                    <td>{{number_format($art->p_venta, 2)}}</td>
                                    <td>{{$art->stock}} / Minimo: {{$art->min_stock}}</td>
                                 
                                    <td>{{$art->codigo}}</td>
                                    <td>


                                        <a class="item btn btn-success" href="{{route('articuloK.show', ['id' => $art->id])}}">
                                            <i class="fa fa-eye" aria-hidden="true"></i>
                                        </a>

                                        <a class="item btn btn-danger" data-toggle="tooltip" data-placement="top" title="" data-original-title="Esta Seguro de Eliminar?" href="{{route('articuloK.delete', ['id' => $art->id])}}" onclick="return confirm('¿Esta Seguro de Eliminar?')">
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </a>

                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection