@extends('layouts.admin')

@section('styles')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css" rel="stylesheet" />
<style>
    #calendar {
        /* max-width: 90%; */
        margin: 0 auto;
        background: white;
        padding: 15px;
        border-radius: 8px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .fc-event {
        cursor: pointer;
    }

    .indicador-color {
        width: 15px;
        height: 15px;
        display: inline-block;
        border: 1px solid rgba(0, 0, 0, 0.1);
        /* Para que se vea si el color es blanco */
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-3 align-items-center">
        <div class="col-md-4">
            <h2 class="text-primary"><i class="fa fa-calendar"></i> Agenda de Citas</h2>
        </div>

        {{-- FILTRO DE DOCTOR --}}
        <div class="col-md-4 ml-auto">
            <label class="font-weight-bold mb-0 mr-2">Filtrar por Doctor:</label>
            <select id="filtroDoctor" class="form-control shadow-sm">
                <option value="">-- Ver Todos --</option>
                @foreach($doctores as $doc)
                <option value="{{ $doc->id }}">{{ $doc->nombre }} </option>
                @endforeach
            </select>
        </div>
    </div>

    {{-- ✨ AQUÍ FALTABA EL CALENDARIO ✨ --}}
    <div class="row">
        <div class="col-10">
            <div id="calendar"></div>
        </div>

        <div class="col-md-2">


            <!-- Button trigger modal -->
            <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#NOTASDEAGENDA">
                NOTAS DE AGENDA
            </button>

            <!-- Modal -->
            <div class="modal fade" id="NOTASDEAGENDA" tabindex="-1" role="dialog" aria-labelledby="NOTADEAGENGA" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">NOTA DE AGENDA</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <p>
                                <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#contentId" aria-expanded="false"
                                    aria-controls="contentId">
                                    NUEVA NOTA
                                </button>
                            </p>
                            <div class="collapse" id="contentId">
                                <form action="{{route('agenda.createNota')}}" method="POST">
                                    @csrf

                                    <div class="form-group">
                                        <label for="nota">Nota</label>
                                        <input type="text" class="form-control" id="nota" name="nota" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="fecha">Fecha</label>
                                        <input type="date" class="form-control" id="fecha" name="fecha" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="doctor">Doctor</label>
                                        <select class="form-control" id="doctor" name="doctor" required>
                                            <option value="">-- Seleccione Un Doctor --</option>
                                            @foreach ($doctores as $doc)
                                            <option value="{{ $doc->nombre }}">{{ $doc->nombre }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <button type="submit" class="btn btn-primary">Guardar</button>

                                </form>
                            </div>

                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>NOTA</th>
                                        <th>FECHA</th>
                                        <th>DOCTOR</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($notas as $nota)
                                    <tr>
                                        <td> {{ $nota->nota }} </td>
                                        <td> {{ $nota->fecha }}</td>
                                        <td> {{ $nota->doctor }}</td>
                                        <td>
                                            <form action="{{route('agenda.deleteNota', $nota)}}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger" onclick="return confirm('¿Estas Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                            </form>

                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRA</button>
                        </div>
                    </div>
                </div>
            </div>

            <ul class="list-group list-group-numbered">

                @foreach ($doctores as $doc )
                <li class="list-group-item">
                    {{$doc->nombre}}


                    <span class="indicador-color rounded-circle"
                        style="background-color: <?php echo $doc->color ?? '#007bff' ?>;"
                        title="{{ $doc->nombre }}">
                    </span>
                </li>
                @endforeach


            </ul>


        </div>
    </div>

</div>

<div class="modal fade" id="eventoModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalTitle">Agendar Cita</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="formAgenda">
                    @csrf
                    <input type="hidden" id="idCita"> {{-- Para editar --}}

                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Fecha</label>
                            <input type="date" class="form-control" id="fecha" name="fecha" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Hora</label>
                            <input type="time" class="form-control" id="hora" name="hora" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Doctor</label>
                        <select class="form-control" id="doctor_id" name="doctor_id" required>
                            @foreach($doctores as $doc)
                            <option value="{{$doc->id}}">{{$doc->nombre}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Paciente (Registrado)</label>
                        <select class="form-control" id="paciente_id" name="paciente_id">
                            <option value="">-- Nuevo / No Registrado --</option>
                            @foreach($pacientes as $pac)
                            <option value="{{$pac->id}}">{{$pac->nombre}}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Input manual por si no selecciona uno de la lista --}}
                    <div class="form-group" id="divPacienteTexto">
                        <label>Nombre Paciente (Manual)</label>
                        <input type="text" class="form-control" id="paciente_text" name="paciente_text">
                    </div>

                    <div class="form-group">
                        <label>Tratamiento / Motivo</label>
                        <input type="text" class="form-control" id="tratamiento" name="tratamiento">
                    </div>

                    <div class="form-group">
                        <label>Observaciones</label>
                        <textarea class="form-control" id="observaciones" name="observaciones" rows="2"></textarea>
                    </div>

                    {{-- Solo visible al editar --}}
                    <div class="form-group d-none" id="divEstado">
                        <label>Estado</label>
                        <select class="form-control" id="estado" name="estado">
                            <option value="PENDIENTE">PENDIENTE</option>
                            <option value="REALIZADO">REALIZADO</option>
                            <option value="CANCELADO">CANCELADO</option>
                        </select>
                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger d-none" id="btnEliminar">Eliminar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="btnGuardar">Guardar Cita</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/locales/es.js"></script> {{-- Español --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');
        var filtroDoctor = document.getElementById('filtroDoctor');

        var calendar = new FullCalendar.Calendar(calendarEl, {
            locale: 'es',

            // --- CONFIGURACIÓN DE HORARIO ---
            slotMinTime: '07:30:00',
            slotMaxTime: '19:30:00',
            slotDuration: '00:20:00', // Celdas de 20 min
            allDaySlot: true,

            businessHours: {
                daysOfWeek: [0, 1, 2, 3, 4, 5, 6], // Domingo a Sábado
                startTime: '07:30',
                endTime: '19:30',
            },

            // --- VISTAS Y BOTONES ---
            initialView: 'dayGridMonth',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
            },

            // --- OPCIONES INTERACTIVAS ---
            editable: true,
            droppable: true,
            dayMaxEvents: true,

            // --- CARGA DE EVENTOS ---
            events: {
                url: "{{ route('agenda.getEvents') }}",
                extraParams: function() {
                    // Envía el ID del doctor seleccionado al controlador
                    return {
                        doctor_id: filtroDoctor.value
                    };
                }
            },

            // 1. CREAR CITA (Click en espacio vacío)
            dateClick: function(info) {
                limpiarModal();

                if (info.dateStr.indexOf('T') > -1) {
                    // Si hizo clic en una hora específica (Semana/Día)
                    let fechaHora = info.dateStr.split('T');
                    $('#fecha').val(fechaHora[0]);
                    $('#hora').val(fechaHora[1].substring(0, 5));
                } else {
                    // Si hizo clic en un día del mes (sin hora)
                    $('#fecha').val(info.dateStr);
                    $('#hora').val('09:00'); // Hora por defecto
                }

                $('#modalTitle').text('Agendar Cita'); // Aseguramos título correcto
                $('#eventoModal').modal('show');
            },

            // 2. EDITAR CITA (Click en evento existente)
            eventClick: function(info) {
                var event = info.event;
                var props = event.extendedProps;

                // Llenar datos básicos
                $('#idCita').val(event.id);
                $('#doctor_id').val(props.doctor_id);
                $('#paciente_id').val(props.paciente_id).trigger('change');
                $('#paciente_text').val(props.paciente_text);
                $('#tratamiento').val(props.tratamiento);
                $('#observaciones').val(props.observaciones);
                $('#estado').val(props.estado);

                // --- CORRECCIÓN DE FECHA Y HORA ---
                // Validamos si el string de fecha tiene tiempo ('T')
                let fechaIso = '';
                let horaIso = '';

                if (event.startStr.indexOf('T') > -1) {
                    fechaIso = event.startStr.split('T')[0];
                    horaIso = event.startStr.split('T')[1].substring(0, 5);
                } else {
                    // Caso raro: evento sin hora (todo el día)
                    fechaIso = event.startStr;
                    horaIso = '09:00';
                }

                $('#fecha').val(fechaIso);
                $('#hora').val(horaIso);
                // ----------------------------------

                // Configuración visual del modal
                $('#divEstado').removeClass('d-none');
                $('#btnEliminar').removeClass('d-none');
                $('#modalTitle').text('Editar Cita');
                $('#eventoModal').modal('show');
            },

            // 3. ARRASTRAR Y SOLTAR (Cambio rápido)
            eventDrop: function(info) {
                var id = info.event.id;
                var nuevaFecha = info.event.startStr;

                Swal.fire({
                    title: '¿Mover cita?',
                    text: "Se reprogramará para: " + new Date(nuevaFecha).toLocaleString(),
                    icon: 'question', // Queda mejor 'question' que 'warning'
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Sí, mover',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            // Usamos la ruta dinámica de Blade para evitar errores de URL hardcodeada
                            // El '/0' es un placeholder que reemplazamos por el ID real
                            url: "{{ url('admin/agenda/actualizar') }}/" + id,
                            type: "PUT",
                            data: {
                                _token: "{{ csrf_token() }}",
                                fecha_nueva: nuevaFecha
                            },
                            success: function(response) {
                                const Toast = Swal.mixin({
                                    toast: true,
                                    position: 'top-end',
                                    showConfirmButton: false,
                                    timer: 3000
                                });
                                Toast.fire({
                                    icon: 'success',
                                    title: 'Cita actualizada'
                                });
                            },
                            error: function() {
                                info.revert(); // Si falla el servidor, regresamos el evento
                                Swal.fire('Error', 'No se pudo mover la cita', 'error');
                            }
                        });
                    } else {
                        info.revert(); // Si el usuario cancela, regresamos el evento
                    }
                });
            }
        });

        calendar.render();

        // Recargar eventos al cambiar el select
        filtroDoctor.addEventListener('change', function() {
            calendar.refetchEvents();
        });


        // GUARDAR O ACTUALIZAR (Lógica del Botón)
        $('#btnGuardar').click(function() {
            let id = $('#idCita').val();
            let url = id ? "/admin/agenda/actualizar/" + id : "{{ route('agenda.store') }}";
            let method = id ? "PUT" : "POST";

            let formData = $('#formAgenda').serialize(); // Serializa todos los inputs

            $.ajax({
                url: url,
                type: method,
                data: formData,
                success: function(response) {
                    $('#eventoModal').modal('hide');
                    calendar.refetchEvents(); // Recarga el calendario sin F5

                    Swal.fire({
                        icon: 'success',
                        title: 'Éxito',
                        text: 'Operación realizada correctamente',
                        timer: 2000,
                        showConfirmButton: false
                    });
                },
                error: function(xhr) {
                    alert('Error al guardar. Revisa los campos.');
                }
            });
        });

        // ELIMINAR
        $('#btnEliminar').click(function() {
            let id = $('#idCita').val();
            if (!id) return;

            if (confirm('¿Seguro que deseas eliminar esta cita?')) {
                $.ajax({
                    url: "/admin/agenda/borrar/" + id,
                    type: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        $('#eventoModal').modal('hide');
                        calendar.getEventById(id).remove(); // Lo quita visualmente
                    }
                });
            }
        });

        function limpiarModal() {
            $('#formAgenda')[0].reset();
            $('#idCita').val('');
            $('#divEstado').addClass('d-none');
            $('#btnEliminar').addClass('d-none');
            $('#modalTitle').text('Agendar Cita');
            // Si usas Select2, limpialos aquí también
        }

        // Lógica simple: Si selecciona paciente existente, desactiva el campo de texto manual
        $('#paciente_id').change(function() {
            if ($(this).val()) {
                $('#paciente_text').prop('disabled', true);
            } else {
                $('#paciente_text').prop('disabled', false);
            }
        });

    });
</script>
@endsection