@extends('layouts.admin')

@section('content')

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-9">

            <form action="{{route('agenda.update')}}" method="post">
                @method('put')
                @csrf
                <input type="hidden" name="id" value="{{$id}}">

                <div class="form-group">
                    <label for="doctor_id">Doctor</label>
                    <select class="form-control" name="doctor_id" id="doctor_id">
                        <option value="{{$data->doctor_id}}">{{$data->doctor->nombre}}</option>
                        @foreach ($doctores as $d )
                        <option value="{{$d->id}}">{{$d->nombre}}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group col-md-6">
                    <label for="">Paciente</label>
                    <input type="text" name="paciente" value="{{$data->paciente}}" class="form-control" placeholder="NOMBRE DE PACIENTES" required>
                </div>


                <div class="row">
                    <div class="form-group col">
                        <label for="">Tratamiento</label>
                        <input type="text" name="tratamiento" value="{{$data->tratamiento}}" class="form-control" placeholder="TRATAMIENTO A REALIZAR" required>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group col-md-6">
                        <label for="">Fecha de Cita</label>
                        <input type="date" class="form-control datepicker" name="fecha" value="{{$data->fecha}}" required>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="">Fecha de Cita</label>
                        <input type="time" class="form-control timepicker" name="hora" value="{{$data->hora}}" required>
                    </div>
                </div>

                <button type="submit" class="btn btn-warning">ACTUALIZAR</button>
            </form>


        </div>
    </div>
</div>


@endsection