<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $permissions = [

            // admin panel permissions

            [
                'name' => 'admin_panel_access',
                'description' => 'PERMITE ACCESO AL SISTEMA'
            ],

            // user permissions

            [
                'name' => 'users_access',
            ],

            [
                'name' => 'user_edit',
                'description' => 'PERMITE EDITAR UN USUARIO'
            ],

            [
                'name' => 'user_delete',
                'description' => 'PERMITE ELIMINAR UN USUARIO'

            ],

            [
                'name' => 'user_create',
                'description' => 'PERMITE REGISTRAR UN USUARIO'

            ],

            [
                'name' => 'user_show',
            ],


            // role permissions

            [
                'name' => 'roles_access',
            ],

            [
                'name' => 'role_edit',
            ],

            [
                'name' => 'role_delete',
            ],

            [
                'name' => 'role_create',
            ],

            [
                'name' => 'role_show',
            ],


            // permission permissions

            [
                'name' => 'permissions_access',
            ],

            [
                'name' => 'permission_edit',
            ],

            [
                'name' => 'permission_delete',
            ],

            [
                'name' => 'permission_create',
            ],
            // ABONOS
            [
                'name' => 'abono_store',
                'description' => 'PERRMITE GUARDAR UN ABOMO PARA PACIENTES'
            ],
            [
                'name' => 'abono_recibo',
                'description' => 'PERRMITE IMPRIMIR EL RECIBO DE UN ABONO'
            ],
            [
                'name' => 'abono_delete',
                'description' => 'PERRMITE ELIMINAR EL ABONO DE UN PACIENTE'
            ],
            [
                'name' => 'agenda_all',
                'description' => 'PERMITE TENER EL CONTROL TOTAL DE AGENDA'
            ],
            // caja
            [
                'name' => 'caja_registro_cajachica',
                'description' => 'PERMITE REGISTRAR DATOS EN CAJA CHICA'
            ],
            [
                'name' => 'caja_registro_gastos',
                'description' => 'PERMITE REGISTRAR GASTOS'
            ],
            [
                'name' => 'caja_cuadre',
                'description' => 'PERMITE REALIZAR UN CUADRE'
            ],
            [
                'name' => 'caja_cuadre_delete',
                'description' => 'PERMITE ELIMINAR REPORTE DE CUADRES DE CAJA'
            ],
            [
                'name' => 'caja_delete_cajachica',
                'description' => 'PERMITE ELIMINAR UN DATO DE CAJA CHICA'
            ],
            [
                'name' => 'caja_delete_gasto',
                'description' => 'PERMITE ELIMINAR UN DATO DE GASTOS'
            ],
            [
                'name' => 'caja_filtrado_cajachica',
                'description' => 'PERMITE VER MOVIMIENTOS DE CAJA CHICA FILTRADOS'
            ],
            [
                'name' => 'caja_filtrado_gastos',
                'description' => 'PERMITE VER MOVIMIENTOS DE GASTOS FILTRADOS'
            ],
            [
                'name' => 'caja_movimientos_filtrados',
                'description' => 'PERMITE VER LOS MOVIMIENTOS DEL MES / FILTRADOS'
            ],
            [
                'name' => 'caja_movimientos_dia',
                'description' => 'PERMITE VER LOS MOVIMIENTOS DEL DIA'
            ],
            // CATEGORIAS
            [
                'name' => 'categoria_list',
                'description' => 'PERMITE LISTAR TODAS LAS CATEGORIAS'
            ],
            [
                'name' => 'categoria_show',
                'description' => 'PERMITE VER EL PERFIL DE CATEGORIAS / ACTUALIZAR'
            ],
            [
                'name' => 'categoria_delete',
                'description' => 'PERMITE ELIMINAR UNA CATEGORIA'
            ],
            [
                'name' => 'categoria_create',
                'description' => 'PERMITE CREAR UNA NUEVA CATEGORIA'
            ],
            [
                'name' => 'categoria_report',
                'description' => 'PERMITE GENERAR EL REPORTE DE CATEGORIAS'
            ],
            // DOCTORES
            [
                'name' => 'doctor_pagosprint',
                'description' => 'PERMITE IMPRIMIR EL PAGO DE LOS DOCTORES'
            ],
            [
                'name' => 'doctor_reportes',
                'description' => 'PERMITE VER REPORTES DISPONIBLES PARA DOCTORES'
            ],
            [
                'name' => 'doctor_store',
                'description' => 'PERMITE REGISTRAR UN NUEVO DOCTOR'
            ],
            [
                'name' => 'doctor_show',
                'description' => 'PERMITE VISUALIZAR EL PERFIL DE CADA DOCTOR'
            ],
            [
                'name' => 'doctor_update',
                'description' => 'PERMITE ACTUALIZAR LOS DATOS DE UN DOCTOR'
            ],
            [
                'name' => 'doctor_delete',
                'description' => 'PERMITE ELIMINAR A UN DOCTOR'
            ],
            // fotos
            [
                'name' => 'fotos_all',
                'description' => 'PERMITE CONTROL TOTAL DE MODULO DE FOTOS'
            ],
            // insumos
            [
                'name' => 'insumo_allreport',
                'description' => 'PERMITE VISUALIZAR REPORTE DE TODOS LOS INSUMOS REGISTRADOS'
            ],
            [
                'name' => 'insumo_salidasreport',
                'description' => 'PERMITE VISUALIZAR REPORTE DE SALIDAS DE INSUMOS'
            ],
            [
                'name' => 'insumo_salidas',
                'description' => 'PERMITE LISTAR LAS SALIDAS DE INSUMOS'
            ],
            [
                'name' => 'insumo_salidaStore',
                'description' => 'PERMITE REGISTRAR LA SALIDA DE UN INSUMO'
            ],
            [
                'name' => 'insumo_salidaDelete',
                'description' => 'PERMITE ELIMINAR LA SALIDA DE UN INSUMO'
            ],
            [
                'name' => 'insumo_list',
                'description' => 'PERMITE LISTAR TODOS LOS INSUMOS REGISTRADOS'
            ],
            [
                'name' => 'insumo_store',
                'description' => 'PERMITE REGISTRAR UN NUEVO INSUMO'
            ],
            [
                'name' => 'insumo_update',
                'description' => 'PERMITE ACTUALIZAR UN INSUMO'
            ],
            [
                'name' => 'insumo_delte',
                'description' => 'PERMITE ELIMINAR UN INSUMO'
            ],

            // MEDICAMENTOS    

            [
                'name' => 'medicamento_listado',
                'description' => 'PERMITE LISTAR TODOS LOS MEDICAMENTOS'
            ],
            [
                'name' => 'medicamento_show',
                'description' => 'PERMITE VER Y ACTUALIZR EL PERFIL DE LOS MEDICAMENTOS'
            ],
            [
                'name' => 'medicamento_store',
                'description' => 'PERMITE REGISTAR UN NUEVO MEDICAMENTO'
            ],
            [
                'name' => 'medicamento_delete',
                'description' => 'PERMITE ELIMINAR UN MEDICAMENTO'
            ],
            [
                'name' => 'medicamento_min_stock',
                'description' => 'PERMITE VISUALIZAR LOS MEDICAMENTOS CON MINIMO DE STOCK'
            ],
            [
                'name' => 'medicamento_compra_store',
                'description' => 'PERMITE GUARDAR UNA COMPRA DE UN MEDICAMENTO YA EXISTENTE'
            ],
            [
                'name' => 'medicamento_historial',
                'description' => 'PERMITE VER EL HISTORIAL DE COMPRAS DE LOS MEDICAMENTOS'
            ],
            [
                'name' => 'medicamento_hitorial_delete',
                'description' => 'PERMITE ELIMINAR UN MEDICAMENTO DEL HISTORIAL DE COMPRAS'
            ],
            [
                'name' => 'medicamento_report_all',
                'description' => 'PERMITE VER TODOS LOS REPORTES DE LOS MEDICAMENTOS'
            ],

            // MOBILIARIO Y EQUIPO
            [
                'name' => 'mobiliario_store',
                'description' => 'PERMITE REGISTRAR UN NUEVO MOBILIARIO Y EQUIPO'
            ],
            [
                'name' => 'mobiliario_listado',
                'description' => 'PERMITE LISTAR TODO DE MOBILIARIO Y EQUIPO'
            ],
            [
                'name' => 'mobiliario_delete',
                'description' => 'PERMITE ELIMINAR UN MOBILIARIO Y EQUIPO'
            ],
            [
                'name' => 'mobiliario_update',
                'description' => 'PERMITE ACTUALIZAR  MOBILIARIO Y EQUIPO'
            ],
            [
                'name' => 'mobiliario_report',
                'description' => 'PERMITE GENERAR UN REPORTE DE MOBILIARIO Y EQUIPO'
            ],

            // PACIENTES
            [
                'name' => 'paciente_store',
                'description' => 'PERMITE REGISTRAR UN NUEVO PACIENTE'
            ],
            [
                'name' => 'paciente_listado',
                'description' => 'PERMITE LISTAR TODOS LOS PACIENTES'
            ],
            [
                'name' => 'paciente_delete',
                'description' => 'PERMITE ELIMINAR UN PACIENTE'
            ],
            [
                'name' => 'paciente_report',
                'description' => 'PERMITE GENERAR REPORTES PARA PACIENTE'
            ],
            [
                'name' => 'paciente_deudores',
                'description' => 'PERMITE VISUALIZAR TODOS LOS PACIENTES DEUDRES'
            ],
            [
                'name' => 'paciente_perfil',
                'description' => 'PERMITE VISUALIZAR TODOS LOS DATOS DE UN PACIENTE'
            ],
            // PROVEEDORES  
            [
                'name' => 'proveedor_list',
                'description' => 'PERMITE LISTAR A TODOS LOS PROVEEDORES'
            ],
            [
                'name' => 'proveedor_all',
                'description' => 'PERMITE VISUALIZAR EL PERFIL DE CADA PROVEEDOR PARA ACTUALIZAR DATOS Y ASIGNAR FACTURAS DE PAGO'
            ],


            // pagos de facturas
            [
                'name' => 'pagosfactura_store',
                'description' => 'PERMITE REGISTRAR UN NUEVO PAGO DE FACTURA'
            ],
            [
                'name' => 'pagosfactura_listado',
                'description' => 'PERMITE LISTAR TODO LOS PAGOS DE FACTURA'
            ],
            [
                'name' => 'pagosfactura_delete',
                'description' => 'PERMITE ELIMINAR UN PAGO DE FACTURA'
            ],
            [
                'name' => 'pagosfactura_report',
                'description' => 'PERMITE GENERAR UN REPORTE DE PAGO DE FACTURAS'
            ],
            // PAGO DE TRATAMIENTOS A DOCTORES
            [
                'name' => 'pagodoctor_store',
                'description' => 'PERMITE REGISTRAR UN NUEVO PAGO DE DOCTOR'
            ],
            [
                'name' => 'pagodoctor_listado',
                'description' => 'PERMITE LISTAR TODOS LOS PAGO DE DOCTOR'
            ],
            [
                'name' => 'pagodoctor_delete',
                'description' => 'PERMITE ELIMINAR UN PAGO DE DOCTOR'
            ],
            [
                'name' => 'pagodoctor_update',
                'description' => 'PERMITE ACTUALIZAR PAGO DE DOCTOR'
            ],
            [
                'name' => 'pagodoctor_report',
                'description' => 'PERMITE GENERAR UN REPORTE COMO PAGAR LOS TRATAMIENTOS A LOS DOCTORES CON GANANCIA DE LA CLINICA'
            ],

            // TRATAMIENTOS
            [
                'name' => 'tratamiento_store',
                'description' => 'PERMITE REGISTRAR UN NUEVO TRATAMIENTO'
            ],
            [
                'name' => 'tratamiento_listado',
                'description' => 'PERMITE LISTAR TODOS LOS TRATAMIENTOS'
            ],
            [
                'name' => 'tratamiento_delete',
                'description' => 'PERMITE ELIMINAR UN TRATAMIENTO'
            ],
            [
                'name' => 'tratamiento_update',
                'description' => 'PERMITE ACTUALIZAR UN TRATAMIENTO'
            ],
            [
                'name' => 'tratamiento_report',
                'description' => 'PERMITE GENERAR REPORTE DE TRATAMIENTOS'
            ],
            // USUARIOS
            [
                'name' => 'usuario_storeActividad',
                'description' => 'PERMITE REGISTRAR UNA NUEVA ACTIVIDAD DE USUARIO'
            ],
            [
                'name' => 'usuario_actividades',
                'description' => 'PERMITE LISTAR TODAS LAS ACTIVIDADES DE LOS USARIOS'
            ],
            [
                'name' => 'usuario_actividaddelete',
                'description' => 'PERMITE ELIMINAR UNA ACTIVIDAD'
            ],
            [
                'name' => 'usuario_checklist',
                'description' => 'PERMITE VER EL CHECK LIST DE LOS USUARIOS'
            ],
            [
                'name' => 'usuario_cabiarCheck',
                'description' => 'PERMITE GENERAR CAMBIAR EL ESTADO DEL CHECK LIST'
            ],
            [
                'name' => 'users_userReport',
                'description' => 'PERMITE GENERAR REPORTE DE CHECK LIST DE UN USUARIO'
            ],
            //   VENTAS
            [
                'name' => 'venta_inicio',
                'description' => 'PERMITE REALIZAR VENTAS E IMPRIMIR RECIBOS'
            ],
            [
                'name' => 'venta_historial',
                'description' => 'PERMITE VER EL HITORIAL DE VENTAS'
            ],
            [
                'name' => 'venta_recibo',
                'description' => 'PERMITE LA REIMPRESION DE RECIBOS DE VETAS'
            ],
            [
                'name' => 'venta_anulacion',
                'description' => 'PERMITE LA ANULACION DE UNA VENTA'
            ],
            [
                'name' => 'venta_reports',
                'description' => 'PERMITE GENERAR TODOS LOS REPORTES DE VENTAS'
            ],


        ];

        foreach ($permissions as $permission) {
            Permission::create($permission);
        }
    }
}
