<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMoreDataToSalidaInsumos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('salida_insumos', function (Blueprint $table) {
            $table->foreignId('lote_insumo_id')->nullable()->constrained('lotes_insumos'); // Agregar la columna lote_insumo_id
            // $table->foreign('lote_insumo_id')->references('id')->on('lotes_insumos'); // Agregar la relación con lotes_insumos
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('salida_insumos', function (Blueprint $table) {
            $table->dropForeign(['lote_insumo_id']); // Eliminar la relación con lotes_insumos
            $table->dropColumn('lote_insumo_id'); // Eliminar la columna lote_insumo_id
        });
    }
}
