<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLotesInsumosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('lotes_insumos', function (Blueprint $table) {
            $table->id();

            $table->foreignId('insumo_id')->constrained('insumos')->onDelete('cascade');
            $table->double('cantidad', 7, 2);
            $table->date('fecha_vencimiento')->nullable();
            $table->string('factura', 25)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('lotes_insumos');
    }
}
