<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterToVentaArticulos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('venta_articulos', function (Blueprint $table) {
            // $table->dropColumn('cantidad');
            $table->foreignId('lote_stock_id')->constrained('lote_stocks')->nullable()->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('venta_articulos', function (Blueprint $table) {
            $table->dropForeign(['lote_stock_id']);
            $table->dropColumn('lote_stock_id');
        });
    }
}
