<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLoteStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('lote_stocks', function (Blueprint $table) {
            $table->id();

            $table->foreignId('articulo_id')->constrained('articulos')->onDelete('cascade');
            $table->double('cantidad', 7, 2);
            $table->date('fecha_caducidad')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('lote_stocks');
    }
}
