<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateToOrtodoncias extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ortodoncias', function (Blueprint $table) {

            $table->dropForeign(['paciente_id']);
            $table->dropColumn('paciente_id');
            $table->text('paciente', 600);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ortodoncias', function (Blueprint $table) {
            $table->bigInteger('paciente_id')->unsigned();
            $table->foreign('paciente_id')->references('id')->on('pacientes');
            $table->dropColumn('paciente');
        });
    }
}
