<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProtesis3sTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('protesis_3', function (Blueprint $table) {
            $table->id();

            $table->bigInteger('paciente_id')->unsigned();
            $table->foreign('paciente_id')->references('id')->on('pacientes');
            $table->string('hoja', 3)->nullable();
            $table->date('fecha')->nullable();
            $table->string('pieza', 10, 3)->nullable();
            $table->string('traumatismo', 10)->nullable();
            $table->string('caries', 10)->nullable();
            $table->string('expocariosa', 10)->nullable();
            $table->string('expomecanica', 10)->nullable();
            $table->string('resdeficiente', 10)->nullable();
            $table->string('rdp', 10)->nullable();
            $table->string('pulpotomia', 10)->nullable();
            $table->string('pulpectomia', 10)->nullable();
            $table->string('tcr', 10)->nullable();
            $table->string('dolorAsintomatico', 10)->nullable();
            $table->string('dolorEspontaneo', 10)->nullable();
            $table->string('dolorProvocado', 10)->nullable();
            $table->string('dolorLocalizado', 10)->nullable();
            $table->string('dolorDifuso', 10)->nullable();
            $table->string('dolorCorto', 10)->nullable();
            $table->string('dolorProlongado', 10)->nullable();
            $table->string('edema', 10)->nullable();
            $table->string('pruebaAsintomatica', 10)->nullable();
            $table->string('pruebaCorta', 10)->nullable();
            $table->string('pruebaprolongada', 10)->nullable();
            $table->string('mucosaAsintomatica', 10)->nullable();
            $table->string('mucosaSintomatica', 10)->nullable();
            $table->string('percusionAsintomatica', 10)->nullable();
            $table->string('percusionLeve', 10)->nullable();
            $table->string('percusionSevera', 10)->nullable();
            $table->string('estadoNormal', 10)->nullable();
            $table->string('estadoMovilidad', 10)->nullable();
            $table->string('estadoSignificativa', 10)->nullable();
            $table->string('fistulaAusente', 10)->nullable();
            $table->string('fistulaPresente', 10)->nullable();
            $table->string('rNormal', 10)->nullable();
            $table->string('lpd', 10)->nullable();
            $table->string('radiomax', 10)->nullable();
            $table->string('radiomin', 10)->nullable();
            $table->string('curvatura', 10)->nullable();
            $table->string('rInt', 10)->nullable();
            $table->string('rExt', 10)->nullable();
            $table->string('obturacion', 10)->nullable();
            $table->string('radicular', 10)->nullable();
            $table->string('perforacion', 10)->nullable();
            $table->string('poste', 10)->nullable();
            $table->string('rfracturado', 10)->nullable();
            $table->string('apiceinmaduro', 10)->nullable();
            $table->string('preversible', 10)->nullable();
            $table->string('pirreversible', 10)->nullable();
            $table->string('nrecosis', 10)->nullable();
            $table->string('paa', 10)->nullable();
            $table->string('aaa', 10)->nullable();
            $table->string('pac', 10)->nullable();
            $table->string('aac', 10)->nullable();
            $table->string('afenix', 10)->nullable();
            $table->string('osteitis', 10)->nullable();
            $table->string('reservado', 10)->nullable();
            $table->string('favorable', 10)->nullable();
            $table->string('observaciones')->nullable();
            $table->string('conductometria')->nullable();
            $table->string('lanatomica')->nullable();
            $table->string('lmaestra')->nullable();
            $table->string('cmaestro')->nullable();
            $table->string('irrigantes')->nullable();
            $table->string('sellador')->nullable();
            $table->string('medicamento')->nullable();
            $table->string('antinflamatorio')->nullable();
            $table->string('antibioterapia')->nullable();
            $table->string('complementarios')->nullable();

            $table->string('mes1', 10)->nullable();
            $table->string('mes3', 10)->nullable();
            $table->string('mes6', 10)->nullable();
            $table->string('cx', 10)->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('protesis_3s');
    }
}
