<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProtesisFijasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('protesis_fijas', function (Blueprint $table) {
            $table->id();

            $table->bigInteger('paciente_id')->unsigned();
            $table->foreign('paciente_id')->references('id')->on('pacientes');
            $table->string('hoja', 3)->nullable();
            $table->string('piezas', 20)->nullable();

            $table->date('fecha1')->nullable();
            $table->date('fecha2')->nullable();
            $table->date('fecha3')->nullable();
            $table->date('fecha4')->nullable();
            $table->date('fecha5')->nullable();
            $table->date('fecha6')->nullable();
            $table->date('fecha7')->nullable();
            $table->date('fecha8')->nullable();
            $table->date('fecha9')->nullable();
            $table->date('fecha10')->nullable();
            $table->string('doc1', 50)->nullable();
            $table->string('doc2', 50)->nullable();
            $table->string('doc3', 50)->nullable();
            $table->string('doc4', 50)->nullable();
            $table->string('doc5', 50)->nullable();
            $table->string('doc6', 50)->nullable();
            $table->string('doc7', 50)->nullable();
            $table->string('doc8', 50)->nullable();
            $table->string('doc9', 50)->nullable();
            $table->string('doc10', 50)->nullable();
            $table->string('cortes', 150)->nullable();
            $table->string('cementadocon', 150)->nullable();
            $table->string('cementarios', 150)->nullable();
            $table->string('tecnicautilizada', 150)->nullable();
            $table->string('pruebametal', 150)->nullable();
            $table->string('espesor3mm', 150)->nullable();
            $table->string('bizcocho', 150)->nullable();
            $table->string('colorpieza', 150)->nullable();
            $table->string('pontico', 150)->nullable();
            $table->string('pre_cementado', 150)->nullable();
            $table->string('e_exceso', 150)->nullable();
            $table->string('cementadadocon2', 150)->nullable();
            $table->string('observaciones', 150)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('protesis_fijas');
    }
}
