<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVentaKanausesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('venta_kanauses', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('articulo_id')->unsigned();
            $table->foreign('articulo_id')->references('id')->on('articulo_kanauses');

            $table->string('cliente')->nullable()->default('Consumidor Final');
            $table->string('nit')->nullable()->default('C/F');

            $table->bigInteger('factura_id')->unsigned();
            $table->foreign('factura_id')->references('id')->on('facturas');

            $table->char('credito', 10);
            $table->double('cantidad');
            $table->double('total');
            $table->double('descuento');
            $table->binary('mayorista')->nullable(true);
    
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('venta_kanauses');
    }
}
