<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateArticuloKanausesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('articulo_kanauses', function (Blueprint $table) {
            $table->id();

            $table->bigInteger('color_id')->unsigned();
            $table->foreign('color_id')->references('id')->on('colors');

            $table->bigInteger('bodega_id')->unsigned();
            $table->foreign('bodega_id')->references('id')->on('bodega_kanauses');

            $table->string('talla', 4);

            $table->double('p_venta', 7, 2);
            $table->double('p_costo', 7, 2);
            $table->double('stock', 7, 2)->nullable();
            $table->double('min_stock')->nullable()->default('0');
            $table->string('codigo')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('articulo_kanauses');
    }
}
