<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToDeudaPacientesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('deuda_pacientes', function (Blueprint $table) {

            $table->bigInteger('tratamiento_id')->unsigned();
            $table->bigInteger('doctor_id')->unsigned();
            $table->string('pieza', 5)->nullable();

            $table->foreign('doctor_id')->references('id')->on('doctores');
            $table->foreign('tratamiento_id')->references('id')->on('tratamientos');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('deuda_pacientes', function (Blueprint $table) {
            $table->bigInteger('tratamiento_id')->unsigned();
            $table->string('pieza', 5)->nullable();
        });
    }
}
