<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePagoDocotoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pago_docotores', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('doctor_id')->unsigned();
            $table->bigInteger('paciente_id')->unsigned();
            $table->bigInteger('tratamiento_id')->unsigned();
            $table->string('pieza', 5);

            $table->foreign('doctor_id')->references('id')->on('doctores');
            $table->foreign('paciente_id')->references('id')->on('pacientes');
            $table->foreign('tratamiento_id')->references('id')->on('tratamientos');

            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pago_docotores');
    }
}
