<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUserIdToCompraArticulos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('compra_articulos', function (Blueprint $table) {
            $table->bigInteger('user_id')->unsigned()->after('articulo_id');
            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('compra_articulos', function (Blueprint $table) {
            $table->bigInteger('user_id')->unsigned()->after('articulo_id');
        });
    }
}
