<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateArticulosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('articulos', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('cod_barras');
            $table->string('descripcion')->nullable();
            $table->text('descripcion_interna')->nullable();
            $table->double('p_venta', 7, 2);
            $table->double('p_costo', 7, 2);
            $table->double('stock', 7, 2);
            $table->double('min_stock')->nullable()->default('0');
            $table->text('img')->nullable(true)->default('');
            $table->text('img2')->nullable(true)->default('');
            $table->date('fecha_promo')->nullable(true);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('articulos');
    }
}
