<?php

use Facade\Ignition\Tabs\Tab;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDoctoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('doctores', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('email');
            $table->text('password');
            $table->double('porcentaje')->nullable();
            $table->string('tel_casa', 10)->nullable();
            $table->string('tel_oficina', 10)->nullable();
            $table->string('tel_celular', 10)->nullable();
            $table->string('especialidad')->nullable();
            $table->string('colegiado')->nullable();
            $table->string('cuentas')->nullable();
            $table->boolean('web')->default(false);
            $table->string('foto')->nullable();
            $table->string('titulo1')->nullable();
            $table->string('titulo2')->nullable();
            $table->string('titulo3')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('doctores');
    }
}
