<?php

use App\Models\Abono;
use App\Models\PagoDoctor;
use App\Models\PagoTratamiento;
use App\Models\ControlUser;
use App\Models\DiarioPaciente;
use App\Models\Procedimiento;
use App\Models\SalidaInsumo;
use App\Models\Tratamiento;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

// mejoras de uno en uno

function pacientesPendientes($tratamiento_id, $inicio, $fin)
{
    return Procedimiento::where('tratamiento_id', $tratamiento_id)->where('estado_pago', '0')->whereBetween('created_at', [$inicio, $fin])->get();
}


function getEliminadao() {}


function getNotaToProcedimiento($doctor_id, $paciente_id, $tratamiento_id, $pieza)
{
    return Procedimiento::where('doctor_id', $doctor_id)->where('paciente_id', $paciente_id)->where('tratamiento_id', $tratamiento_id)->where('pieza', $pieza)->first();
}



function getPagoProcedimiento($doctor_id, $tratamiento_id)
{
    return PagoTratamiento::where('doctor_id', $doctor_id)->where('tratamiento_id', $tratamiento_id)->first();
}

function storeControl($des, $user = '')
{
    $control = new ControlUser();
    $control->user = Auth::user()->name ?? $user;
    $control->descripcion = $des;
    $control->save();
    // dd('alto');
}


function getAbonosToDia($created_at, $paciente_id)
{
    return Abono::whereDate('created_at', $created_at)->where('paciente_id', $paciente_id)->get();
}

function getAbonoToTratamiento($created_at, $paciente_id, $tratamiento_id)
{
    return Abono::whereDate('created_at', $created_at)->where('paciente_id', $paciente_id)->where('tratmiento_id', $tratamiento_id)->first();
}


function searSalidaInsumo($paciente_id, $created_at)
{
    return SalidaInsumo::where('paciente_id', $paciente_id)->whereDate('created_at', $created_at)->first();
}


function sumAbonosToDate($fecha)
{
    return Abono::whereDate('created_at', $fecha)->sum('valor');
}

function subProcedimientoToDate($fecha)
{
    return Procedimiento::whereDate('fecha', $fecha)->sum('valor');
}

function getDeudaLaboratorio($laboratorio_id, $mes, $anio)
{
    $consumido =  DB::table('paciente_l_aboratorios as  pl')
        ->join('pacientes as pac', 'pl.paciente_id', '=', 'pac.id')
        ->join('laboratorios as lab', 'pl.laboratorio_id', '=', 'lab.id')
        ->select('pl.total', 'pl.descripcion', 'pl.created_at', 'lab.nombre', 'pl.id', 'pac.nombre as paciente')
        ->where('pl.laboratorio_id', $laboratorio_id)
        ->whereYear('pl.created_at', $anio)
        ->whereMonth('pl.created_at', $mes)
        ->get();

    $total = 0;
    foreach ($consumido as $con) {
        $total += $con->total;
    }
    return $total;
}


function cantidadTratamientosDoctor($doctor_id, $mes, $anio)
{
    return PagoDoctor::where('doctor_id', $doctor_id)->whereYear('created_at', $anio)->whereMonth('created_at', $mes)->count();
}

function getTotalProcedimientosDoctor($doctor_id, $mes, $anio)
{
    return Procedimiento::where('doctor_id', $doctor_id)->whereYear('fecha', $anio)->whereMonth('fecha', $mes)->where('fecha', '!=', null)->sum('valor');
}

function getPagoDoctor($doctor_id, $mes, $anio)
{

    $pagos =  PagoDoctor::where('doctor_id', $doctor_id)->whereYear('created_at', $anio)->whereMonth('created_at', $mes)->get();
    $total_pago = 0;
    for ($i = 0; $i < count($pagos); $i++) {

        // para buscar los procentajes de pago
        $pagoTatamiento = PagoTratamiento::where('doctor_id', $doctor_id)
            ->where('tratamiento_id', $pagos[$i]->tratamiento_id)
            ->first();

        // dd($pagoTatamiento, $pagos[$i], $pagos[$i]->tratamiento->precio);

        $total_pago = $total_pago +  (($pagoTatamiento->porcentaje ?? 0)  * ($pagos[$i]->tratamiento->precio ?? 0) / 100)  + ($pagoTatamiento->monto  ?? 0);
    }

    return $total_pago;
}


// TRE LOS PACIENTE QUE ESTAN ASIGANSOD A UN TRATAMIENTO QUE NO SE HA REALIZADO
function getPacientesSinTratamiento($tratamiento_id)
{
    return Procedimiento::where('tratamiento_id', $tratamiento_id)->where('fecha', null)->get();
}


function getDairioToFecha($paciente_id, $created_at)
{
    return DiarioPaciente::where('paciente_id', $paciente_id)->whereDate('created_at', $created_at)->get();
}

function getUltimoDoctor($paciente_id)
{

    return Procedimiento::where('paciente_id', $paciente_id)->orderBy('id', 'desc')->first();
}
