<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tratamiento extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'tratamientos';
    public $guarded = [];



    // Un tratamiento tiene muchos procedimientos agendados
    public function procedimientos()
    {
        return $this->hasMany(Procedimiento::class, 'tratamiento_id', 'id');
    }
}
