<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RecordatorioPaciente extends Model
{
    use HasFactory;

    protected $table = 'recordatorio_paciente';
    public $guarded = [];

    /**
     * Relacion con el paciente al que pertenece el recordatorio
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */

    public function paciente()
    {
        return $this->hasOne('App\Models\Paciente', 'id', 'paciente_id');
    }
}
