<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Procedimiento extends Model
{
    use HasFactory, SoftDeletes;
    public $guarded = [];
    protected $softDelete = true;

    // CORRECTO: El procedimiento PERTENECE a un tratamiento
    public function tratamiento()
    {
        return $this->belongsTo(Tratamiento::class, 'tratamiento_id');
    }

    /*************  ✨ Windsurf Command ⭐  *************/
    /**
     * Get the paciente that owns the Procedimiento
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
    /*******  5613c61b-b236-444d-9cb6-55dd74a2b7ac  *******/
    public function paciente()
    {
        return $this->belongsTo(Paciente::class, 'paciente_id');
    }

    /**
     * Get the doctor that owns the Procedimiento
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function doctor()
    {
        return $this->belongsTo(Doctor::class);
    }
}
