<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Paciente extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'pacientes';
    public $guarded = ['webcam_image'];


    /**
     * Get all of the abonos for the Procedimiento
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function abonoModel(): HasMany
    {
        return $this->hasMany(Abono::class);
    }

    /**
     * Get the procedimientos that owns the Paciente
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function procedimientos(): HasMany
    {
        return $this->hasMany(Procedimiento::class);
    }
}
