<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LoteInsumo extends Model
{
    use HasFactory;

    protected $guarded = [];
    protected $table = 'lotes_insumos';


    /**
     * Get the insumo that owns the LoteInsumo
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function insumo(): BelongsTo
    {
        return $this->belongsTo(Insumo::class);
    }

    public function salidas()
    {
        // Asumiendo que 'salida_insumos' tiene una columna 'lote_insumo_id'
        return $this->hasMany(SalidaInsumo::class, 'lote_insumo_id');
    }
}
