<?php

namespace App\Mail;

use App\Models\Agenda;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PacienteAgendaDoctor extends Mailable
{
    use Queueable, SerializesModels;

    public $id;
   
    public function __construct($id)
    {
        $this->id = $id;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $agenda = Agenda::find($this->id);
        return $this->view('mail.agenda-doctor', ['data' => $agenda]);
    }
}
