<?php

namespace App\Http\Controllers\Doctor;

use App\Http\Controllers\Controller;
use App\Models\Agenda;
use App\Models\Doctor;
use App\Models\Paciente;
use App\Models\PagoDoctor;
use App\Models\PagoTratamiento;
use App\Models\Procedimiento;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Yajra\DataTables\Facades\DataTables;

class AuthDoctorController extends Controller
{


    function login_index()
    {
        return view('doctor.auth.login');
    }

    function login(Request $request)
    {
        $contra = $request->password;
        $doc = Doctor::where('email', $request->email)->first();


        if (!$doc) {
            return redirect()->route('login_doctor');
            alert()->warning('Doctor', 'Datos Incorrectos');
        }

        if ($doc) {
            alert()->success('Doctor', 'Sesion Iniciada');
            $request->session()->regenerate();
            session(['doctor_id' => $doc->id]);
            session(['doctor' => $doc]);
            return redirect()->route('doc.home');
        } else {
            alert()->warning('Doctor', 'Datos Incorrectos');
            return redirect()->route('login_doctor');
        }
    }

    function home()
    {

        $pagos = DB::table('pago_docotores as pd')
            ->join('tratamientos as tr', 'pd.tratamiento_id', '=', 'tr.id')
            ->join('pacientes as pac', 'pd.paciente_id', '=', 'pac.id')
            ->select(
                'pd.pieza',
                'pd.created_at',
                'tr.nombre as tratamiento',
                'tr.descripcion as descripcionTr',
                'tr.id as tratamiento_id',
                'tr.precio',
                'tr.tipo',
                'pac.nombre'
            )
            ->where('pd.doctor_id', session()->get('doctor_id'))
            ->whereMonth('pd.created_at', date('m'))
            ->whereYear('pd.created_at', date('Y'))
            ->orderBy('pd.id', 'desc')
            ->get();

        $hoy = date('Y-m-d');
        $manana = date('Y-m-d', strtotime($hoy . ' + 1 day'));

        $agendaHoy = Agenda::where('doctor_id', session()->get('doctor_id'))
            ->whereDate('fecha', $hoy)
            ->get();

        $agendaManana = Agenda::where('doctor_id', session()->get('doctor_id'))
            ->whereDate('fecha', $manana)
            ->get();

        return view('doc.home', compact('pagos', 'agendaHoy', 'agendaManana'));
    }

    function logout(Request $request)
    {
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        $request->session()->flush();
        return redirect()->route('login_doctor');
    }

    // 1. Solo retorna la vista contenedora
    public function pacientesHoy()
    {
        return view('doc.pacientes');
    }

    // 2. Procesa los datos via AJAX
    public function getPacientesAjax(Request $request)
    {
        if ($request->ajax()) {
            // Seleccionamos solo lo necesario
            $pacientes = Paciente::select(['id', 'nombre']);

            return DataTables::of($pacientes)
                ->addColumn('acciones', function ($paciente) {
                    // Aquí reconstruimos el formulario HTML que tenías en el Blade
                    // Usamos la ruta correcta pasando el ID del paciente
                    $url = route('doc.paciente-showPaciente', $paciente->id);

                    // Generamos las opciones del select (1 al 10)
                    $options = '<option value="">Hoja</option>';
                    for ($i = 1; $i <= 10; $i++) {
                        $options .= '<option value="' . $i . '">' . $i . '</option>';
                    }

                    // Retornamos el HTML completo del formulario
                    return '
                        <form action="' . $url . '" method="get" class="d-flex align-items-center gap-2">
                            <div class="form-group mb-0">
                                <select class="form-control form-control-sm" name="hoja">
                                    ' . $options . '
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary btn-sm">
                                <i class="fa fa-search"></i>
                            </button>
                        </form>
                    ';
                })
                ->rawColumns(['acciones']) // Permitimos HTML en esta columna
                ->make(true);
        }
    }

    function updateProcedimiento(Request $request, $id)
    {
        $procedi = Procedimiento::find($id);
        $procedi->recomendacion = $request->recomendacion;
        $procedi->save();
        alert()->success('Paciente', 'Datos Actualizados');
        return redirect()->back();
    }

    function updateProcedimientoajax(Request $request)
    {

        $procedi = Procedimiento::find($request->procedimiento_id);
        $procedi->recomendacion = $request->recomendacion;
        $procedi->save();
        alert()->success('Paciente', 'Datos Actualizados');
        return Response::json([
            'request' => $request->all(),
            'data' => $procedi
        ]);
    }

    function pacientestredias(Request $request)
    {
        $hoy = date('Y-m-d');
        $tres_atras = date("d-m-Y", strtotime($hoy . "- 2 days"));
        $procedimientos = Procedimiento::where('doctor_id', $request->session()->get('doctor_id'))
            ->whereBetween('fecha', [$tres_atras, $hoy])
            ->get();
        // dd($procedimientos);
        return view('doc.pacientes', compact('procedimientos'));
    }


    function reportes()
    {

        return view('doc.reportes');
    }


    public function prindPagos($id, Request $request)
    {
        $pagos = DB::table('pago_tratamientos as pg')
            ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
            ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
            ->select('doc.nombre as doctor', 'doc.especialidad', 'tr.nombre as tratamiento', 'tr.precio', 'tr.tipo', 'pg.porcentaje', 'pg.id', 'tr.precio')
            ->where('doc.id', $id)
            ->get();

        return view('reports.tratamientos.pagos', ['pagos' => $pagos, 'titulo' => 'Pagos Doctor', 'visible' => false]);
    }


    public function reportPagoDocto($id, Request $request)
    {

        $doctore = Doctor::find($id);
        $historial = DB::table('pago_docotores as pd')
            ->join('tratamientos as tr', 'pd.tratamiento_id', '=', 'tr.id')
            ->join('pacientes as pac', 'pd.paciente_id', '=', 'pac.id')
            ->select(
                'pd.pieza',
                'pd.created_at',
                'tr.nombre as tratamiento',
                'tr.descripcion as descripcionTr',
                'tr.id as tratamiento_id',
                'tr.precio',
                'tr.tipo',
                'pac.nombre',
                'pac.id as paciente_id'
            )
            ->where('pd.doctor_id', $id)
            ->whereMonth('pd.created_at', $request->mes)
            ->whereYear('pd.created_at', $request->ano)
            ->orderBy('pd.id', 'desc')
            ->get();

        $total_pago = 0;

        for ($i = 0; $i < count($historial); $i++) {

            // para buscar los procentajes de pago
            $pagoTatamiento = PagoTratamiento::where('doctor_id', $id)
                ->where('tratamiento_id', $historial[$i]->tratamiento_id)
                ->first();
            $total_pago = $total_pago + (($pagoTatamiento->porcentaje ?? 0) * $historial[$i]->precio) / 100;
        }

        $descu = DB::table('descuento_doctors as des')
            ->select('des.*')
            ->where('des.doctor_id', $id)
            ->whereMonth('des.created_at', $request->mes)
            ->whereYear('des.created_at', $request->ano)
            ->get();


        return view('reports.doctores.pagos', ['doctore' => $doctore, 'historial' => $historial, 'total_Pago' => $total_pago, 'descuentos' => $descu]);
    }
}
