<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ArticuloKanaus;
use App\Models\ArticulosKanaus;
use App\Models\Factura;
use App\Models\Venta;
use App\Models\VentaKanaus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class VentaKanausController extends Controller
{

    public function index()
    {
        $articulos = DB::table('articulo_kanauses as art')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select('art.talla', 'art.id', 'art.p_venta', 'art.codigo', 'bod.nombre as bodega', 'col.nombre as color', 'art.stock', 'art.min_stock', 'art.codigo')
            ->where('art.deleted_at', null)
            ->where('art.stock', '>', 0)
            ->get();
        //// ------------------------

        return view('admin.ventasK.index', ['articulos' => $articulos]);
    }

    // crea una venta
    public function store(Request $data)
    {
        $vuelta =  count($data->idArticulos);
        $factura = new Factura();


        $mayorista = false;
        if ($data->mayorista_check) {
            $mayorista = true;
        }
        if ($data->mayorista_check == null) {
            $mayorista = false;
        }


        $newdescuento = 0;
        if ($data->descuento_mayo) {
            $factura->descuento = $data->descuento_mayo;
            $newdescuento =  $data->totalventa -  $data->descuento_mayo;
            $mayorista = true;
        }

        if ($data->descripcion) {
            $factura->descripcion =  $data->descripcion;
        }

        $factura->total = $data->totalventa;
        $factura->descripcion_min = $data->des_min;
        $factura->mayoristas = $mayorista;

        // asiganos el nuevo descueto para mayoriastas


        $factura->total_des = $newdescuento;

        $factura->save();

        $cliente = $data->cliente;

        // dd($data->crediro);
        $credito = false;
        if ($data->credito) {
            $credito = true;
        }
        if ($data->credito == null) {
            $credito = false;
        }

        if (!$data->cliente) {
            $cliente = 14;
        }

        // dd($data->all());


        for ($i = 0; $i < $vuelta; $i++) {
            $venta = new VentaKanaus();
            $venta->articulo_id = $data->idArticulos[$i];
            $venta->cliente = $data->cliente;
            $venta->cliente = $cliente;
            $venta->factura_id = $factura->id;
            $venta->credito = $credito;
            $venta->cantidad = $data->cantidad[$i];
            $venta->descuento = $data->descuento[$i];
            $venta->mayorista = $mayorista;
            $venta->total = $data->subtotal[$i];
            $venta->save();
        }
        return back()->with(['info' => 'Venta Registrada con Exito', 'color' => 'success', 'factura' => $factura->id, 'clienteid' => $cliente]);
    }

    // paga una venta al credito
    public function pagarCredito($id)
    {
        $venta = Venta::find($id);

        $venta->credito = false;

        $venta->save();

        return back()->with(['info' => 'Articulo Cancelado', 'color' => 'success']);
    }

    // imprime la factura de una venta realizada
    public function ventaPrint($idFactura)
    {
        $deuda = DB::table('venta_kanauses AS ven')
            ->join('articulo_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.cantidad',
                'ven.total',
                'ven.credito',
                'ven.mayorista',
                'ven.descuento',
                'ven.cliente',
                'art.talla  as nomArt',
                'art.codigo',
                'art.p_venta',
                'fac.created_at as fechaVenta',
                'fac.descuento as facDescuento',
                'fac.total as facTotal',
                'fac.id as factura_id',
                'col.nombre as color',
                'bod.nombre as bodega',
                'ven.cliente'
            )
            ->where('factura_id', '=' , $idFactura)
            ->get();



        $facturaVenta = Factura::find($idFactura);

        $totalDeuda = 0;
        $nombre = '';
        $fecha = date('Y');
        $nit = 0;
        $descuento_articulo = 0;
        $sin_desc = 0;
        $mayorista = false;
        $facTotal = 0;

        $aux3 = 0;




        foreach ($deuda as $deu) {
            $totalDeuda =  $deu->total + $totalDeuda;
            $nombre = $deu->cliente;
            $fecha = $deu->fechaVenta;
            $descuento_articulo = $descuento_articulo + $deu->descuento;
            $sin_desc = ($sin_desc + $deu->p_venta) * $deu->cantidad;
            $facTotal = $deu->facTotal;
            // echo $deu->cantidad;

            if ($deu->mayorista == 1) {
                $mayorista = true;

                $aux3 = $aux3 + $deu->total;
            }
        }


        // sin desc = 600
        // descuento articuo = 5
        // dd($aux3);
        // die();




        return view('reports.ventasK.venta', ['deuda' => $deuda, 'totalDeuda' => $totalDeuda, 'cliente' => $nombre, 'factura' => $facturaVenta, 'fecha' => $fecha, 'nit' => $nit, 'descuetoArticulos' => $descuento_articulo, 'sin_desc' => $sin_desc, 'mayorista' => $mayorista, 'facTotal' => $facTotal, 'totalSinDecMayo' => $aux3]);
    }

    // devuelve el hoitorial de las ventas realizadas
    public function historial()
    {
        $deuda = DB::table('venta_kanauses AS ven')
            ->join('articulo_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.cantidad',
                'ven.total',
                'ven.credito',
                'ven.mayorista',
                'ven.descuento',
                'ven.cliente',
                'art.talla  as nomArt',
                'art.codigo',
                'art.p_venta',
                'fac.created_at as fechaVenta',
                'fac.descuento as facDescuento',
                'fac.total as facTotal',
                'fac.id as factura_id',
                'col.nombre as color',
                'bod.nombre as bodega',
                'ven.cliente',
                'art.id as articulo_id'
            )
            ->get();

      

        return view('admin.ventas.historial', ['contado' => $deuda, ]);
    }

    // elimina una venta y actualiza el stock en los articulos
    public function destroy($id, $idArt)
    {
        $venta = VentaKanaus::where('factura_id', $id)->get();

        foreach ($venta as $venta) {
            $articulo = ArticuloKanaus::find($venta->articulo_id);
            $articulo->stock = $articulo->stock + $venta->cantidad;
            $articulo->save();
            $venta->delete();
        }

        return back()->with(['info' => 'Venta Anulda Con Exito', 'color' => 'danger']);
    }

    // devuelve la vista para los reportes
    public function reportes()
    {
        return view('admin.ventasK.reportes');
    }

    // devuelve la vista para reporte de todas las ventas 
    public function reportesVentasAll(Request $data)
    {
        $ventas = DB::table('venta_kanauses AS ven')
            ->join('articulos_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.total',
                'ven.descuento',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'ven.cliente',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )
            ->whereMonth('ven.created_at', $data->mes)
            ->whereYear('ven.created_at', $data->ano)
            ->where('ven.mayorista', false)
            ->get();

        // dd($ventas);


        // return $ventas;

        $ventas_mayoristas = DB::table('venta_articulos AS ven')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.created_at as fechaVenta',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )
            ->whereMonth('ven.created_at', $data->mes)
            ->whereYear('ven.created_at', $data->ano)
            ->where('ven.mayorista', true)
            ->groupBy('fac.id')
            ->get();

        $ventas_mayoristas2 = DB::table('venta_articulos AS ven')
            ->join('articulos_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.total',
                'ven.descuento',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'ven.cliente',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )
            ->whereMonth('ven.created_at', $data->mes)
            ->whereYear('ven.created_at', $data->ano)
            ->where('ven.mayorista', true)
            ->get();
        $ventasEsperadasMayo = 0;

        foreach ($ventas_mayoristas2 as $ventaMayo) {
            $ventasEsperadasMayo = $ventasEsperadasMayo + $ventaMayo->total;
        }


        $total = 0;
        foreach ($ventas as $ven) {
            $total = $ven->total + $total;
            // echo $total, '.', $ven->total, '<br>';
        }

        // die();
        return view('reports.ventas.ventas', ['ventas' => $ventas, 'total' => $total, 'mes' => $data->mes, 'ano' => $data->ano, 'ventas_mayo' => $ventas_mayoristas, 'total_mayo' => $ventasEsperadasMayo]);
    }

    // devuelve la vista para imprimir reportes de ventas al contado
    public function reportesVentasContado(Request $data)
    {
        $ventas = $this->ventasContado($data->mes, $data->ano);
        $total = 0;
        foreach ($ventas as $ven) {
            $total = $ven->total + $total;
        }
        return view('reports.ventas.ventas', ['ventas' => $ventas, 'total' => $total, 'tipo' => 'al contado', 'mes' => $data->mes, 'ano' => $data->ano]);
    }

    // devuelve la vista par imprimir reportes de ventas al credito
    public function reportesVentasCredito(Request $data)
    {
        $ventas = $this->ventasCrediro($data->mes, $data->ano);
        $total = 0;
        foreach ($ventas as $ven) {
            $total = $ven->total + $total;
        }

        return view('reports.ventas.ventas', ['ventas' => $ventas, 'total' => $total, 'tipo' => 'al credito', 'mes' => $data->mes, 'ano' => $data->ano]);
    }

    // ---------------------------------------------------
    // ventas all
    public function allventas($mes, $ano)
    {
        $ventas = DB::table('venta_kanauses AS ven')
            ->join('articulos_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.cliente',
                'ven.total',
                'ven.descuento',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )
            ->whereMonth('ven.created_at', $mes)
            ->whereYear('ven.created_at', $ano)
            // ->where('ven.mayorista' ,'!=', true)
            ->get();

        return $ventas;
    }

    // ventas al contado
    public function ventasContado($mes, $ano)
    {
        $deuda = DB::table('venta_kanauses AS ven')
            ->join('articulo_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.cantidad',
                'ven.total',
                'ven.credito',
                'ven.mayorista',
                'ven.descuento',
                'ven.cliente',
                'art.talla  as talla',
                'art.codigo',
                'art.p_venta',
                'art.p_costo',
                'fac.created_at as fechaVenta',
                'fac.descuento as facDescuento',
                'fac.total as facTotal',
                'fac.id as factura_id',
                'col.nombre as color',
                'bod.nombre as bodega',
                'ven.cliente',
                'art.id as articulo_id'
            )
            ->where('ven.credito', 0)
            ->whereMonth('ven.created_at', $mes)
            ->whereYear('ven.created_at', $ano)
            ->get();
        return $deuda;
    }

    // ventas al credito
    public function ventasCrediro($mes, $ano)
    {
        $credito = DB::table('venta_kanauses AS ven')

            ->join('articulos_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.total',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'ven.cliente',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'ven.descuento'
            )
            ->where('ven.credito', 1)
            ->whereMonth('ven.created_at', $mes)
            ->whereYear('ven.created_at', $ano)
            ->get();
        return $credito;
    }

    public function ventasDia()
    {
        $deuda = DB::table('venta_kanauses AS ven')
        ->join('articulo_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
        ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
        ->join('colors as col', 'art.color_id', '=', 'col.id')
        ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
        ->select(
            'ven.id',
            'ven.factura_id',
            'ven.cantidad',
            'ven.total',
            'ven.credito',
            'ven.mayorista',
            'ven.descuento',
            'ven.cliente',
            'art.talla  as talla',
            'art.codigo',
            'art.p_venta',
            'art.p_costo',
            'fac.created_at as fechaVenta',
            'fac.descuento as facDescuento',
            'fac.total as facTotal',
            'fac.id as factura_id',
            'col.nombre as color',
            'bod.nombre as bodega',
            'ven.cliente',
            'art.id as articulo_id'
        )
        ->where('ven.credito', 0)
        ->whereDate('ven.created_at', date('Y-m-d'))
        ->get();

        return view('reports.ventas.dia', ['ventas' => $deuda]);
    }

    // ultimos movimientos
    public function movimientos()
    {
        $ventas = DB::table('venta_kanauses AS ven')
            ->join('articulos_kanauses AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.total',
                'ven.descuento',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )
            ->whereDate('ven.created_at', date('Y-m-d'))
            // ->where('ven.mayorista' ,'!=', true)
            ->take(15)
            ->get();


        return view('reports.ventas.dia', ['ventas' => $ventas]);
    }


    // retorna la vista para las estadisticas
    public function estadistica()
    {
        $estadisticasano = $this->estadis();
        $masVendidos = $this->masVendidos();


        // for ($i = 0; $i < sizeof($this->movimientoMes()); $i++) {
        //     foreach ($this->movimientoMes()[$i] as $movi) {

        //         echo $movi->created_at . ':';
        //         echo $movi->cuadre .'<br>';
        //     }
        // }

        // dd();
        return view('reports.ventas.estadistica', ['datos' => $estadisticasano, 'masVendidos' => $masVendidos]);
    }

    // retorna los datos de entradas de efectico
    // para construir las graficas estadisticass
    public function estadis()
    {

        $ventasEnero = $this->ventasMes(1);
        $ventasFebrero = $this->ventasMes(2);
        $ventasMarzo = $this->ventasMes(3);
        $ventasAbril = $this->ventasMes(4);
        $ventasMayo = $this->ventasMes(5);
        $ventasJunio = $this->ventasMes(6);
        $ventasJulio = $this->ventasMes(7);
        $ventasAgosto = $this->ventasMes(8);
        $ventasSptiembre = $this->ventasMes(9);
        $ventasOctubre = $this->ventasMes(10);
        $ventasNoviembre = $this->ventasMes(11);
        $ventasDiciembre = $this->ventasMes(12);
        $totales = array();
        $total1 = 0;
        $total2 = 0;
        $total3 = 0;
        $total4 = 0;
        $total5 = 0;
        $total6 = 0;
        $total7 = 0;
        $total8 = 0;
        $total9 = 0;
        $total10 = 0;
        $total11 = 0;
        $total12 = 0;

        foreach ($ventasEnero as $venta) {
            $total1 = $total1 +  $venta->cuadre;
        }
        foreach ($ventasFebrero as $venta) {
            $total2 = $total2 +  $venta->cuadre;
        }
        foreach ($ventasMarzo as $venta) {
            $total3 = $total3 +  $venta->cuadre;
        }

        foreach ($ventasAbril as $venta) {
            $total4 = $total4 +  $venta->cuadre;
        }
        foreach ($ventasMayo as $venta) {
            $total5 = $total5 +  $venta->cuadre;
        }
        foreach ($ventasJunio as $venta) {
            $total6 = $total6 +  $venta->cuadre;
        }
        foreach ($ventasJulio as $venta) {
            $total7 = $total7 +  $venta->cuadre;
        }
        foreach ($ventasAgosto as $venta) {
            $total8 = $total8 +  $venta->cuadre;
        }
        foreach ($ventasSptiembre as $venta) {
            $total9 = $total9 +  $venta->cuadre;
        }
        foreach ($ventasOctubre as $venta) {
            $total10 = $total10 +  $venta->cuadre;
        }
        foreach ($ventasNoviembre as $venta) {
            $total11 = $total11 +  $venta->cuadre;
        }
        foreach ($ventasDiciembre as $venta) {
            $total12 = $total12 +  $venta->cuadre;
        }

        array_push($totales, $total1, $total2, $total3, $total4, $total5, $total6, $total7, $total8, $total9, $total10, $total11, $total12);

        return $totales;
    }

    // retorna  los cuadres de caja por mes
    public function ventasMes($mes)
    {
        $data =
            DB::table('cuadres')
            ->whereMonth('created_at', $mes)
            ->whereYear('created_at', date('Y'))
            ->get();
        return $data;
    }

    // retorna un listadode articulos mas vendidos
    public function masVendidos()
    {
        $data =  DB::table('venta_kanauses')
            ->join('articulos_kanauses as art', 'venta_kanauses.articulo_id', '=', 'art.id')
            ->select(DB::raw('COUNT(venta_kanauses.articulo_id) as idArticulo'), 'venta_kanauses.factura_id', 'art.nombre', 'art.descripcion')
            ->groupBy('venta_kanauses.articulo_id')
            ->orderBy(DB::raw('venta_kanauses.articulo_id'), 'desc')
            ->limit(25)
            ->get();
        $data2 = array();
        foreach ($data as $d) {
            array_push($data2, $d);
        }
        return $data2;
    }

    public function movimientoMes()
    {
        $dias = array();
        for ($i = 0; $i < 32; $i++) {
            $data =
                DB::table('cuadre')
                ->whereDay('created_at', $i)
                ->whereMonth('created_at', date('m'))
                ->whereYear('created_at', date('Y'))
                ->get();
            array_push($dias, $data);
        }
        return $dias;
    }
}
