<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\StoreUserRequest;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use App\Models\Actividad;
use App\Models\CheckList;
use App\Models\ControlUser;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        abort_if(Gate::denies('users_access'), Response::HTTP_FORBIDDEN, 'Forbidden');

        $users = User::with('role')->where('deleted_at', null)
            ->where('email', '!=', 'ariel12jona@gmail.com')
            ->paginate(5)->appends($request->query());
        return view('admin.users.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        abort_if(Gate::denies('user_create'), Response::HTTP_FORBIDDEN, 'Forbidden');

        $roles = Role::pluck('title', 'id');
        return view('admin.users.create', compact('roles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUserRequest $request)
    {
        User::create($request->validated());
        return back()->with(['info' => 'Usuario Creado con Exito', 'color' => 'success']);
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User  $permission
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        abort_if(Gate::denies('user_show'), Response::HTTP_FORBIDDEN, 'Forbidden');

        return view('admin.users.show', compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        abort_if(Gate::denies('user_edit'), Response::HTTP_FORBIDDEN, 'Forbidden');

        // dd($user);

        $roles = Role::pluck('title', 'id');
        return view('admin.users.edit', compact('user', 'roles'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        $user->update($request->all());

        return redirect()->route('users.index')->with(['info' => 'Usuario Actualizado', 'color' => 'warning']);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        abort_if(Gate::denies('user_delete'), Response::HTTP_FORBIDDEN, 'Forbidden');

        $user->delete();
        return redirect()->back()->with(['info' => 'Usuario Eliminado Con Exito', 'color' => 'danger']);
    }

    // -------------------------
    //          CHECL LIST
    //  ------------------------

    // retorna la vista para crear actividades y listarlass
    public function actividades()
    {
        $actividades = DB::table('actividads as ac')
            ->join('users as user', 'ac.user_id', '=', 'user.id')
            ->select('ac.nombre', 'user.name', 'ac.id', 'user.email')
            ->where('user.email', '!=', 'ariel12jona@gmail.com')
            ->get();

            $user = User::where('email', '!=', 'ariel12jona@gmail.com')->get();

        return view('admin.users.actividades', ['actividades' => $actividades, 'users' => $user]);
    }

    public function storeActividad(Request $request)
    {
        Actividad::create($request->all());
        return back()->with(['info' => 'Actividad Asiganada con Exito', 'color' => 'success']);
    }

    public function deleteactividad($id)
    {
        Actividad::find($id)->delete();
        return back()->with(['info' => 'Actividad Eliminada con Exito', 'color' => 'danger']);
    }

    // retorna la vista de cheklist del Usuario
    public function checkList($id)
    {

        $che = DB::table('check_lists as che')
            ->join('actividads as ac', 'che.actividads_id', '=', 'ac.id')
            ->select('che.id', 'ac.nombre')
            ->where('ac.user_id', '=', $id)
            ->whereDate('che.created_at', date('Y-m-d'))
            ->count();
        $user = User::find($id);

        $actividades = Actividad::where('user_id', '=', $id)->get();

        // dd($actividades);

        // evaluamos si echiste el cheklist de hoy si no se crea
        if ($che === 0) {

            for ($i = 0; $i < count($actividades); $i++) {
                $check = new CheckList();

                $check->actividads_id = $actividades[$i]->id;
                $check->estado = 'NO';

                $check->save();
            }

            $che = DB::table('check_lists as che')
                ->join('actividads as ac', 'che.actividads_id', '=', 'ac.id')
                ->select('che.id', 'ac.nombre', 'che.estado')
                ->where('ac.user_id', '=', $id)
                ->whereDate('che.created_at', date('Y-m-d'))
                ->get();

            return view('reports.users.checkList', ['lists' => $che, 'user' => $user]);
        }

        if ($che >= 1) {

            $che = DB::table('check_lists as che')
                ->join('actividads as ac', 'che.actividads_id', '=', 'ac.id')
                ->select('che.id', 'ac.nombre', 'che.estado')
                ->where('ac.user_id', '=', $id)
                ->whereDate('che.created_at', date('Y-m-d'))
                ->get();

            return view('reports.users.checkList', ['lists' => $che, 'user' => $user]);
        }
    }

    // cambia el estado de una terea de un check list
    public function cabiarCheck($id)
    {
        $che = CheckList::find($id);

        if ($che->estado === 'no' || $che->estado === 'NO') {
            $che->estado = 'SI';
            $che->save();

            return back()->with(['info' => 'datos actualizados', 'color' => 'success']);
        }

        if ($che->estado === 'SI' || $che->estado === 'si') {
            $che->estado = 'NO';
            $che->save();

            return back()->with(['info' => 'datos actualizados', 'color' => 'success']);
        }
    }

    // retonra la vista para reporte de usuarios para
    public function userReport()
    {
        $user = User::where('email', '!=', 'ariel12jona@gmail.com')->get();

        return view('admin.users.report', ['users' => $user]);
    }


    // retorna el reporte de CheckList de un usario
    public function reporteChekListo(Request $request)
    {
        $che = DB::table('check_lists as che')
            ->join('actividads as ac', 'che.actividads_id', '=', 'ac.id')
            ->select('che.id', 'ac.nombre', 'che.created_at', 'che.estado')
            ->where('ac.user_id', '=', $request->user_id)
            ->whereBetween('che.created_at', [$request->desde, $request->hasta])
            ->orderBy('che.created_at', 'desc')
            ->get();
        $user = User::find($request->user_id);

        // dd($che);

        return view('reports.users.checkReport', ['lists' => $che, 'user' => $user]);
    }

    function reportAcciones(Request $request) {
        $op = ControlUser::where('user', '=', $request->user_id)->whereBetween('created_at', [$request->inicio, $request->fin])->get();

        // dd($op);

        return view('reports.users.operaciones', compact('op'));
    }
}
