<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Mail\CompraMedicamentos;
use App\Models\Articulo;
use App\Models\SolicitudCompra;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class SolicitudController extends Controller
{


    public function index()
    {
        $data = SolicitudCompra::all();
        $articulos = Articulo::all();
        return view('admin.solicitud.index', compact('data', 'articulos'));
    }
    public function store(Request $request)
    {
        $s = new SolicitudCompra();
        $s->solicitante = $request->solicitante;
        $s->datos =  $request->articulo . ', ' . $request->datos;
        $s->save();
        storeControl('nueva solicitud de compra');

        // Mail::to('ariel12jona@gmail.com')->send(new CompraMedicamentos($s->id));

        return back()->with(['info' => 'solicitud guardado']);
    }
    public function update(Request $request, $id)
    {
        $s = SolicitudCompra::find($id);

        $s->estado = 'APROVADO';
        $s->datos  = $request->datos;
        $s->aprovo = Auth::user()->name;
        $s->save();

        storeControl('aprovo solicitud de compra de medicamentos');


        return back()->with(['info' => 'solicitud guardado']);
    }
    public function show($id)
    {
        $data = SolicitudCompra::find($id);
        return view('admin.solicitud.show', compact('data'));
    }
    public function delete($id)
    {
        $data = SolicitudCompra::find($id)->delete();
        return back()->with(['info' => 'solicitud eliminado']);
    }
}
