<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Insumo;
use App\Models\LoteInsumo;
use App\Models\SalidaInsumo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SalidaInsumoController extends Controller
{

    function index($paciente_id, $tratamiento_id)
    {
        return view('admin.insumos.salidas.newindex', compact('paciente_id', 'tratamiento_id'));
    }
    public function getLoteData(Request $request)
    {
        $insumoId = $request->input('insumo_id');
        $loteId = $request->input('lote_id');

        $lote = LoteInsumo::with('insumo')
            ->where('id', $loteId)
            ->where('insumo_id', $insumoId)
            ->first();

        if ($lote) {
            return response()->json([
                'id' => $lote->id,
                'cantidad' => $lote->cantidad,
                'fecha_vencimiento' => $lote->fecha_vencimiento,
                'nombre' => $lote->insumo->nombre,
            ]);
        }

        return response()->json(null);
    }



    function searchAjax(Request $request)
    {
        $codigo = $request->codigo;

        $insumos = Insumo::where('nombre', 'LIKE', '%' . $codigo . '%')
            ->with('lotes')
            ->get();

        return response()->json($insumos);
    }

    public function salidaInsutmoStore(Request $request)
    {
        $request->validate([
            'insumo_id' => 'required|array',
            'lote_id' => 'required|array',
            'paciente_id' => 'required|exists:pacientes,id',
            'procedamiento_id' => 'required|exists:procedimientos,id',
        ]);

        for ($i = 0; $i < count($request->insumo_id); $i++) {
            $insumoId = $request->insumo_id[$i];
            $loteId = $request->lote_id[$i];

            $loteInsumo = LoteInsumo::find($loteId);

            if (!$loteInsumo) {
                return back()->with(['info' => "Lote no encontrado para el insumo con ID: $insumoId", 'color' => 'danger']);
            }

            if ($loteInsumo->cantidad <= 0) {
                return back()->with(['info' => "No hay suficiente stock disponible para el insumo: " . $loteInsumo->insumo->nombre, 'color' => 'danger']);
            }

            // Crear registro de salida de insumo
            $salidaInsumo = new SalidaInsumo();
            $salidaInsumo->paciente_id = $request->paciente_id;
            $salidaInsumo->clinica = $request->procedamiento_id;
            $salidaInsumo->cantidad = 1;
            $salidaInsumo->user_id = Auth::user()->id;
            $salidaInsumo->insumo_id = $insumoId;
            $salidaInsumo->lote_insumo_id = $loteId; // Guardar el ID del lote
            $salidaInsumo->save();

            // Actualizar stock del lote
            $loteInsumo->cantidad -= 1;
            $loteInsumo->save();
        }

        storeControl('registro salida de insumos');

        return back()->with(['info' => 'DATOS GUARDADOS CON EXITO', 'color' => 'success']);
    }
}
