<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\RecordatorioGeneral;
use Illuminate\Http\Request;

class RecordatorioGeneralController extends Controller
{

    public function index()
    {
        $recor = RecordatorioGeneral::all();
        // dd($recor);
        return view('admin.recordatorio_general.index', ['data' => $recor]);
    }

    public function edit($id)
    {
        $data = RecordatorioGeneral::findOrFail($id);
        return view('admin.recordatorio_general.edit', ['data' => $data]);
    }

    public function create()
    {
        return view('admin.recordatorio_general.create');
    }

    public function store(Request $request)
    {
        RecordatorioGeneral::create($request->all());
        // dd('entro');
        return back()->with(['info' => 'Recordatorio Guardado', 'color' => 'success']);
    }

    public function update(Request $request, $id)
    {
        RecordatorioGeneral::findOrFail($id)->update($request->all());
        return back()->with(['info' => 'Recordatorio Actualizado', 'color' => 'info']);
    }

    public function destroy($id)
    {
        RecordatorioGeneral::findOrFail($id)->destroy($id);
        return back()->with(['info' => 'Recordatorio Eliminado Con Exito', 'color' => 'danger']);
    }
}
