<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Paciente;
use App\Models\Receta;
use App\Models\RecetaPaciente;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class RecetaController extends Controller
{

    public function index()
    {

        $recetas = Receta::where('created_at', '>=', '2025-03-10')->get();


        return view('admin.recetas.index', ['recetas' => $recetas]);
    }


    public function store(Request $request)
    {
        Receta::create($request->all());
        return back()->with(['info' => 'receta registrado con exito', 'color' => 'success']);
    }


    public function destroy($id)
    {
        Receta::find($id)->delete();
        return back()->with(['info' => 'receta eliminado con exito', 'color' => 'danger']);
    }


    public function recetar()
    {
        $pacientes = Paciente::all();
        $receta = Receta::where('created_at', '>=', '2025-03-10')->get();


        $recetas = DB::table('receta_pacientes as recetas')
            ->join('recetas as rec', 'recetas.receta_id', '=', 'rec.id')
            ->join('pacientes as pac', 'recetas.paciente_id', '=', 'pac.id')
            ->select('recetas.created_at', 'recetas.id', 'pac.nombre', 'pac.direccion', 'rec.nombre as recetaNombre')
            ->orderBy('recetas.id', 'desc')
            ->groupBy('recetas.created_at')
            ->paginate(20);

        return view('admin.recetas.recetar', ['pacientes' => $pacientes, 'recetas' => $receta, 'recetasPac' => $recetas]);
    }

    public function recetarStore(Request $request)
    {
        for ($i = 0; $i < count($request->receta_id); $i++) {
            $receta =  new RecetaPaciente();
            $receta->paciente_id = $request->paciente_id;
            $receta->receta_id = $request->receta_id[$i];
            $receta->save();
        }
        return back()->with(['info' => 'receta agregada con exito', 'color' => 'success']);
    }

    public function printReceta($fecha)
    {
        $recetas = DB::table('receta_pacientes as recetas')
            ->join('recetas as rec', 'recetas.receta_id', '=', 'rec.id')
            ->join('pacientes as pac', 'recetas.paciente_id', '=', 'pac.id')
            ->select('recetas.created_at', 'recetas.id', 'pac.nombre', 'pac.direccion', 'rec.nombre as recetaNombre')
            ->where('recetas.created_at', $fecha)
            ->get();
        $paciente = '';
        $fecha = '';
        foreach ($recetas as $receta) {
            $paciente = $receta->nombre;
            $fecha = $receta->created_at;
        }
        return view('reports.recetas.print', ['recetas' => $recetas, 'paciente' => $paciente, 'fecha' => $fecha]);
    }

    public function printRecetaDos($fecha)
    {
        $recetas = DB::table('receta_pacientes as recetas')
            ->join('recetas as rec', 'recetas.receta_id', '=', 'rec.id')
            ->join('pacientes as pac', 'recetas.paciente_id', '=', 'pac.id')
            ->select('recetas.created_at', 'recetas.id', 'pac.nombre', 'pac.direccion', 'rec.nombre as recetaNombre')
            ->where('recetas.created_at', $fecha)
            ->get();
        $paciente = '';
        $fecha = '';
        foreach ($recetas as $receta) {
            $paciente = $receta->nombre;
            $fecha = $receta->created_at;
        }
        return view('reports.recetas.printpos', ['recetas' => $recetas, 'paciente' => $paciente, 'fecha' => $fecha]);
    }
}
