<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\FacturaProveedor;
use App\Models\Proveedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProveedorController extends Controller
{
   
    public function index()
    {
        return view('admin.proveedores.index', ['data' => Proveedor::all()]);
    }

    public function create()
    {
        return view('admin.proveedores.create');
    }

    public function store(Request $data)
    {
        $proveedor =  new Proveedor($data->all());
        $proveedor->save();
        return back()->with(['info' => "Proveedor $data->nombre Creado Con Exito", 'color' => 'success']);
    }

    public function show($id)
    {
        $prove = Proveedor::find($id);
        $facturas = FacturaProveedor::where('proveedor_id', $id)->count();
        $facturas2 = FacturaProveedor::where('proveedor_id', $id)->orderBy('id', 'ASC')->get();


        return view('admin.proveedores.show', ['data' => $prove, 'numero' => $facturas, 'facturas' => $facturas2]);
    }

    public function update(Request $request, $id)
    {
        Proveedor::find($id)->update($request->all());
        return back()->with(['info' => 'Datos Actualizado Con Exito', 'color' => 'warning']);
    }

    // retorna el reporte de todos los proveedores
    public function reporte()
    {
        return view('reports.proveedores.index', ['data' => Proveedor::all()]);
    }


    // guarda una fatura para el proveedor
    public function facturacreate(Request $request)
    {
        $fatura_proveedor = new FacturaProveedor($request->all());
        $fatura_proveedor->save();
        return back()->with(['info' => 'Factura Asignada con Exito', 'color' => 'success']);
    }

    public function facturadelete($id)
    {
        $factura = FacturaProveedor::find($id);
        $factura->delete();
        return back()->with(['info' => 'Factura Eliminada con Exito', 'color' => 'danger']);
    }


    // retonra grafias estadisticas de articulos mas comprados
    public function mascomprado($id)
    {
        $data =  DB::table('compra_proveedores')
            ->join('articulos as art', 'compra_proveedores.articulo_id', '=', 'art.id')
            ->select(DB::raw('COUNT(compra_proveedores.articulo_id) as idArticulo'), 'compra_proveedores.factura', 'art.nombre', 'art.descripcion')
            ->where('compra_proveedores.proveedor_id', $id)
            ->groupBy('compra_proveedores.articulo_id')
            ->orderBy(DB::raw('compra_proveedores.articulo_id'), 'desc')
            ->limit(25)
            ->get();

        // dd($data);
        $data2 = array();

        foreach ($data as $d) {
            array_push($data2, $d);
        }
        return view('reports.proveedores.mascomprado', ['masVendidos' => $data2]);
    }



    public function delete($id)
    {
        $pro = Proveedor::find($id);
        $pro->delete();
        return back()->with(['info' => 'Proveedor Eliminado Con Exito', 'color' => 'danger']);
    }
}
